/*
 * Decompiled with CFR 0.152.
 */
package org.openpnp.capture;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openpnp.capture.OpenPnpCapture;
import org.openpnp.capture.library.CapFormatInfo;
import org.openpnp.capture.library.OpenpnpCaptureLibrary;

public class CaptureDevice {
    Pointer context;
    int index;
    String name;
    String uniqueId;
    List<CaptureFormat> formats = new ArrayList<CaptureFormat>();

    public CaptureDevice(Pointer context, int index) {
        this.context = context;
        this.index = index;
        this.name = OpenpnpCaptureLibrary.INSTANCE.Cap_getDeviceName(context, index).getString(0L, "UTF8");
        this.uniqueId = OpenpnpCaptureLibrary.INSTANCE.Cap_getDeviceUniqueID(context, index).getString(0L, "UTF8");
        int formatCount = OpenpnpCaptureLibrary.INSTANCE.Cap_getNumFormats(context, index);
        for (int formatIndex = 0; formatIndex < formatCount; ++formatIndex) {
            CapFormatInfo formatInfo = new CapFormatInfo();
            OpenpnpCaptureLibrary.INSTANCE.Cap_getFormatInfo(context, index, formatIndex, formatInfo);
            this.formats.add(new CaptureFormat(formatIndex, formatInfo));
        }
    }

    public CaptureStream openStream(CaptureFormat format) {
        int id = OpenpnpCaptureLibrary.INSTANCE.Cap_openStream(this.context, this.index, format.formatId);
        if (id == -1) {
            return null;
        }
        return new CaptureStream(id, format);
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public List<CaptureFormat> getFormats() {
        return Collections.unmodifiableList(this.formats);
    }

    public class CaptureStream {
        private final int streamId;
        private final CaptureFormat format;
        private final Memory memory;

        public CaptureStream(int streamId, CaptureFormat format) {
            this.streamId = streamId;
            this.format = format;
            this.memory = new Memory(((CaptureFormat)format).formatInfo.width * ((CaptureFormat)format).formatInfo.height * 3);
            this.memory.clear();
        }

        public void close() {
            OpenpnpCaptureLibrary.INSTANCE.Cap_closeStream(CaptureDevice.this.context, this.streamId);
        }

        public synchronized BufferedImage capture() {
            int res = OpenpnpCaptureLibrary.INSTANCE.Cap_captureFrame(CaptureDevice.this.context, this.streamId, this.memory, (int)this.memory.size());
            if (res != 0) {
                return null;
            }
            BufferedImage image = new BufferedImage(((CaptureFormat)this.format).formatInfo.width, ((CaptureFormat)this.format).formatInfo.height, 5);
            byte[] bytes = this.memory.getByteArray(0L, (int)this.memory.size());
            image.getRaster().setDataElements(0, 0, image.getWidth(), image.getHeight(), bytes);
            return image;
        }

        public String toString() {
            return String.format("%d", this.streamId);
        }
    }

    public class CaptureFormat {
        private final int formatId;
        private final CapFormatInfo formatInfo;

        public CaptureFormat(int formatId, CapFormatInfo formatInfo) {
            this.formatId = formatId;
            this.formatInfo = formatInfo;
        }

        public String toString() {
            return String.format("%d x %d, %d FPS, %s", this.formatInfo.width, this.formatInfo.height, this.formatInfo.fps, OpenPnpCapture.fourCcToString(this.formatInfo.fourcc));
        }
    }
}

