/*
 * Decompiled with CFR 0.152.
 */
package org.openpnp.capture;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.awt.image.BufferedImage;
import java.nio.IntBuffer;
import org.openpnp.capture.CaptureException;
import org.openpnp.capture.CaptureFormat;
import org.openpnp.capture.CaptureProperty;
import org.openpnp.capture.OpenPnpCapture;
import org.openpnp.capture.PropertyLimits;
import org.openpnp.capture.library.OpenpnpCaptureLibrary;

public class CaptureStream {
    private final Pointer context;
    private final int streamId;
    private final CaptureFormat format;
    private final Memory memory;

    public CaptureStream(Pointer context, int streamId, CaptureFormat format) {
        this.context = context;
        this.streamId = streamId;
        this.format = format;
        this.memory = new Memory((long)(format.formatInfo.width * format.formatInfo.height * 3));
        this.memory.clear();
    }

    public void close() {
        OpenpnpCaptureLibrary.INSTANCE.Cap_closeStream(this.context, this.streamId);
    }

    public Pointer getContext() {
        return this.context;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public CaptureFormat getFormat() {
        return this.format;
    }

    public PropertyLimits getPropertyLimits(CaptureProperty property) throws Exception {
        IntBuffer min = IntBuffer.allocate(1);
        IntBuffer max = IntBuffer.allocate(1);
        IntBuffer def = IntBuffer.allocate(1);
        int result = OpenpnpCaptureLibrary.INSTANCE.Cap_getPropertyLimits(this.context, this.streamId, property.getPropertyId(), min, max, def);
        if (result != 0) {
            throw new CaptureException(result);
        }
        PropertyLimits limits = new PropertyLimits(min.get(0), max.get(0), def.get(0));
        return limits;
    }

    public void setAutoProperty(CaptureProperty property, boolean on) throws Exception {
        int result = OpenpnpCaptureLibrary.INSTANCE.Cap_setAutoProperty(this.context, this.streamId, property.getPropertyId(), on ? 1 : 0);
        if (result != 0) {
            throw new Exception(OpenPnpCapture.getResultDescription(result));
        }
    }

    public void setProperty(CaptureProperty property, int value) throws Exception {
        int result = OpenpnpCaptureLibrary.INSTANCE.Cap_setProperty(this.context, this.streamId, property.getPropertyId(), value);
        if (result != 0) {
            throw new CaptureException(result);
        }
    }

    public boolean getAutoProperty(CaptureProperty property) throws Exception {
        IntBuffer value = IntBuffer.allocate(1);
        int result = OpenpnpCaptureLibrary.INSTANCE.Cap_getAutoProperty(this.context, this.streamId, property.getPropertyId(), value);
        if (result != 0) {
            throw new CaptureException(result);
        }
        return value.get(0) != 0;
    }

    public int getProperty(CaptureProperty property) throws Exception {
        IntBuffer value = IntBuffer.allocate(1);
        int result = OpenpnpCaptureLibrary.INSTANCE.Cap_getProperty(this.context, this.streamId, property.getPropertyId(), value);
        if (result != 0) {
            throw new CaptureException(result);
        }
        return value.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage capture() throws Exception {
        byte[] bytes;
        Memory memory = this.memory;
        synchronized (memory) {
            int result = OpenpnpCaptureLibrary.INSTANCE.Cap_captureFrame(this.context, this.streamId, (Pointer)this.memory, (int)this.memory.size());
            if (result != 0) {
                throw new CaptureException(result);
            }
            bytes = this.memory.getByteArray(0L, (int)this.memory.size());
        }
        BufferedImage image = new BufferedImage(this.format.formatInfo.width, this.format.formatInfo.height, 5);
        image.getRaster().setDataElements(0, 0, image.getWidth(), image.getHeight(), bytes);
        return image;
    }

    public String toString() {
        return String.format("%d: %s", this.streamId, this.format);
    }
}

