/*
 * Decompiled with CFR 0.152.
 */
package nu.pattern;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.opencv.core.Core;

public class OpenCV {
    private static final Logger logger = Logger.getLogger(OpenCV.class.getName());

    public static void loadShared() {
        SharedLoader.getInstance();
    }

    public static void loadLocally() {
        LocalLoader.getInstance();
    }

    private static Path extractNativeBinary() {
        OS os = OS.getCurrent();
        Arch arch = Arch.getCurrent();
        return OpenCV.extractNativeBinary(os, arch);
    }

    private static Path extractNativeBinary(OS os, Arch arch) {
        String location;
        block1 : switch (os) {
            case LINUX: {
                switch (arch) {
                    case X86_64: {
                        location = "/nu/pattern/opencv/linux/x86_64/libopencv_java451.so";
                        break block1;
                    }
                    case ARMv8: {
                        location = "/nu/pattern/opencv/linux/ARMv8/libopencv_java451.so";
                        break block1;
                    }
                }
                throw new UnsupportedPlatformException(os, arch);
            }
            case OSX: {
                switch (arch) {
                    case X86_64: {
                        location = "/nu/pattern/opencv/osx/x86_64/libopencv_java451.dylib";
                        break block1;
                    }
                }
                throw new UnsupportedPlatformException(os, arch);
            }
            case WINDOWS: {
                switch (arch) {
                    case X86_32: {
                        location = "/nu/pattern/opencv/windows/x86_32/opencv_java451.dll";
                        break block1;
                    }
                    case X86_64: {
                        location = "/nu/pattern/opencv/windows/x86_64/opencv_java451.dll";
                        break block1;
                    }
                }
                throw new UnsupportedPlatformException(os, arch);
            }
            default: {
                throw new UnsupportedPlatformException(os, arch);
            }
        }
        logger.log(Level.FINEST, "Selected native binary \"{0}\".", location);
        InputStream binary = OpenCV.class.getResourceAsStream(location);
        Path destination = OS.WINDOWS.equals((Object)os) ? new TemporaryDirectory().deleteOldInstancesOnStart().getPath().resolve("./" + location).normalize() : new TemporaryDirectory().markDeleteOnExit().getPath().resolve("./" + location).normalize();
        try {
            logger.log(Level.FINEST, "Copying native binary to \"{0}\".", destination);
            Files.createDirectories(destination.getParent(), new FileAttribute[0]);
            Files.copy(binary, destination, new CopyOption[0]);
            binary.close();
        }
        catch (IOException ioe) {
            throw new IllegalStateException(String.format("Error writing native library to \"%s\".", destination), ioe);
        }
        logger.log(Level.FINEST, "Extracted native binary to \"{0}\".", destination);
        return destination;
    }

    private static class LocalLoader {
        private LocalLoader() {
            Path libraryPath = OpenCV.extractNativeBinary();
            System.load(libraryPath.normalize().toString());
            logger.log(Level.FINEST, "OpenCV library \"{0}\" loaded from extracted copy at \"{1}\".", new Object[]{Core.NATIVE_LIBRARY_NAME, System.mapLibraryName(Core.NATIVE_LIBRARY_NAME)});
        }

        public static LocalLoader getInstance() {
            return Holder.INSTANCE;
        }

        private static class Holder {
            private static final LocalLoader INSTANCE = new LocalLoader();

            private Holder() {
            }
        }
    }

    private static class SharedLoader {
        private static final List<String> errorMessages = Arrays.asList(String.format("no %s in java.library.path", Core.NATIVE_LIBRARY_NAME), String.format("%s (Not found in java.library.path)", Core.NATIVE_LIBRARY_NAME));
        private Path libraryPath;

        private SharedLoader() {
            try {
                System.loadLibrary(Core.NATIVE_LIBRARY_NAME);
                logger.log(Level.FINEST, "Loaded existing OpenCV library \"{0}\" from library path.", Core.NATIVE_LIBRARY_NAME);
            }
            catch (UnsatisfiedLinkError ule) {
                if (ule == null || !this.openCVNotFoundInJavaLibraryPath(ule.getMessage())) {
                    logger.log(Level.FINEST, String.format("Encountered unexpected loading error.", new Object[0]), ule);
                    throw ule;
                }
                if (Double.parseDouble(System.getProperty("java.specification.version")) >= 12.0) {
                    logger.log(Level.SEVERE, "OpenCV.loadShared() is not supported in Java >= 12. Falling back to OpenCV.loadLocally().");
                    OpenCV.loadLocally();
                    return;
                }
                this.libraryPath = OpenCV.extractNativeBinary();
                SharedLoader.addLibraryPath(this.libraryPath.getParent());
                System.loadLibrary(Core.NATIVE_LIBRARY_NAME);
                logger.log(Level.FINEST, "OpenCV library \"{0}\" loaded from extracted copy at \"{1}\".", new Object[]{Core.NATIVE_LIBRARY_NAME, System.mapLibraryName(Core.NATIVE_LIBRARY_NAME)});
            }
        }

        private boolean openCVNotFoundInJavaLibraryPath(String errorMessage) {
            for (String errorFragment : errorMessages) {
                if (!errorMessage.contains(errorFragment)) continue;
                return true;
            }
            return false;
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (null == this.libraryPath) {
                return;
            }
            SharedLoader.removeLibraryPath(this.libraryPath.getParent());
        }

        public static SharedLoader getInstance() {
            return Holder.INSTANCE;
        }

        private static void addLibraryPath(Path path) {
            String normalizedPath = path.normalize().toString();
            try {
                Field field = ClassLoader.class.getDeclaredField("usr_paths");
                field.setAccessible(true);
                HashSet<String> userPaths = new HashSet<String>(Arrays.asList((String[])field.get(null)));
                userPaths.add(normalizedPath);
                field.set(null, userPaths.toArray(new String[userPaths.size()]));
                System.setProperty("java.library.path", System.getProperty("java.library.path") + File.pathSeparator + normalizedPath);
                logger.log(Level.FINEST, "System library path now \"{0}\".", System.getProperty("java.library.path"));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to get permissions to set library path");
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Failed to get field handle to set library path");
            }
        }

        private static void removeLibraryPath(Path path) {
            String normalizedPath = path.normalize().toString();
            try {
                Field field = ClassLoader.class.getDeclaredField("usr_paths");
                field.setAccessible(true);
                HashSet<String> userPaths = new HashSet<String>(Arrays.asList((String[])field.get(null)));
                userPaths.remove(normalizedPath);
                field.set(null, userPaths.toArray(new String[userPaths.size()]));
                System.setProperty("java.library.path", System.getProperty("java.library.path").replace(File.pathSeparator + path.normalize().toString(), ""));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to get permissions to set library path");
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Failed to get field handle to set library path");
            }
        }

        private static class Holder {
            private static final SharedLoader INSTANCE = new SharedLoader();

            private Holder() {
            }
        }
    }

    private static class TemporaryDirectory {
        static final String OPENCV_PREFIX = "opencv_openpnp";
        final Path path;

        public TemporaryDirectory() {
            try {
                this.path = Files.createTempDirectory(OPENCV_PREFIX, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Path getPath() {
            return this.path;
        }

        public TemporaryDirectory deleteOldInstancesOnStart() {
            Path tempDirectory = this.path.getParent();
            for (File file : tempDirectory.toFile().listFiles()) {
                if (!file.isDirectory() || !file.getName().startsWith(OPENCV_PREFIX)) continue;
                try {
                    this.delete(file.toPath());
                }
                catch (RuntimeException e) {
                    if (!(e.getCause() instanceof AccessDeniedException)) continue;
                    logger.fine("Failed delete a previous instance of the OpenCV binaries, likely in use by another program: ");
                }
            }
            return this;
        }

        public TemporaryDirectory markDeleteOnExit() {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    TemporaryDirectory.this.delete();
                }
            });
            return this;
        }

        private void delete(Path path) {
            if (!Files.exists(path, new LinkOption[0])) {
                return;
            }
            try {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                        Files.deleteIfExists(dir);
                        return super.postVisitDirectory(dir, e);
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.deleteIfExists(file);
                        return super.visitFile(file, attrs);
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void delete() {
            this.delete(this.path);
        }
    }

    private static class UnsupportedPlatformException
    extends RuntimeException {
        private UnsupportedPlatformException(OS os, Arch arch) {
            super(String.format("Operating system \"%s\" and architecture \"%s\" are not supported.", new Object[]{os, arch}));
        }
    }

    static enum Arch {
        X86_32("i386", "i686", "x86"),
        X86_64("amd64", "x86_64"),
        ARMv8("aarch64", "arm64");

        private final Set<String> patterns;

        private Arch(String ... patterns) {
            this.patterns = new HashSet<String>(Arrays.asList(patterns));
        }

        private boolean is(String id) {
            return this.patterns.contains(id);
        }

        public static Arch getCurrent() {
            String osArch = System.getProperty("os.arch");
            for (Arch arch : Arch.values()) {
                if (!arch.is(osArch)) continue;
                logger.log(Level.FINEST, "Current environment matches architecture descriptor \"{0}\".", (Object)arch);
                return arch;
            }
            throw new UnsupportedOperationException(String.format("Architecture \"%s\" is not supported.", osArch));
        }
    }

    static enum OS {
        OSX("^[Mm]ac OS X$"),
        LINUX("^[Ll]inux$"),
        WINDOWS("^[Ww]indows.*");

        private final Set<Pattern> patterns = new HashSet<Pattern>();

        private OS(String ... patterns) {
            for (String pattern : patterns) {
                this.patterns.add(Pattern.compile(pattern));
            }
        }

        private boolean is(String id) {
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(id).matches()) continue;
                return true;
            }
            return false;
        }

        public static OS getCurrent() {
            String osName = System.getProperty("os.name");
            for (OS os : OS.values()) {
                if (!os.is(osName)) continue;
                logger.log(Level.FINEST, "Current environment matches operating system descriptor \"{0}\".", (Object)os);
                return os;
            }
            throw new UnsupportedOperationException(String.format("Operating system \"%s\" is not supported.", osName));
        }
    }
}

