/*
 * Decompiled with CFR 0.152.
 */
package nu.pattern;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.opencv.core.Core;
import sun.reflect.CallerSensitive;

public class OpenCV {
    private static final Logger logger = Logger.getLogger(OpenCV.class.getName());

    public static void loadShared() {
        SharedLoader.getInstance();
    }

    public static void loadLocally() {
        LocalLoader.getInstance();
    }

    @CallerSensitive
    private static Path extractNativeBinary() {
        OS os = OS.getCurrent();
        Arch arch = Arch.getCurrent();
        return OpenCV.extractNativeBinary(os, arch);
    }

    private static Path extractNativeBinary(OS os, Arch arch) {
        String location;
        block1 : switch (os) {
            case LINUX: {
                switch (arch) {
                    case X86_32: {
                        location = "/nu/pattern/opencv/linux/x86_32/libopencv_java249.so";
                        break block1;
                    }
                    case X86_64: {
                        location = "/nu/pattern/opencv/linux/x86_64/libopencv_java249.so";
                        break block1;
                    }
                }
                throw new UnsupportedPlatformException(os, arch);
            }
            case OSX: {
                switch (arch) {
                    case X86_64: {
                        location = "/nu/pattern/opencv/osx/x86_64/libopencv_java249.dylib";
                        break block1;
                    }
                }
                throw new UnsupportedPlatformException(os, arch);
            }
            case WINDOWS: {
                switch (arch) {
                    case X86_32: {
                        location = "/nu/pattern/opencv/windows/x86_32/opencv_java249.dll";
                        break block1;
                    }
                    case X86_64: {
                        location = "/nu/pattern/opencv/windows/x86_64/opencv_java249.dll";
                        break block1;
                    }
                }
                throw new UnsupportedPlatformException(os, arch);
            }
            default: {
                throw new UnsupportedPlatformException(os, arch);
            }
        }
        logger.log(Level.FINEST, "Selected native binary \"{0}\".", location);
        InputStream binary = OpenCV.class.getResourceAsStream(location);
        Path destination = new TemporaryDirectory().markDeleteOnExit().getPath().resolve("./" + location).normalize();
        try {
            logger.log(Level.FINEST, "Copying native binary to \"{0}\".", destination);
            Files.createDirectories(destination.getParent(), new FileAttribute[0]);
            Files.copy(binary, destination, new CopyOption[0]);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(String.format("Error writing native library to \"%s\".", destination), ioe);
        }
        logger.log(Level.FINEST, "Extracted native binary to \"{0}\".", destination);
        return destination;
    }

    private static class LocalLoader {
        private LocalLoader() {
            Path libraryPath = OpenCV.extractNativeBinary();
            System.load(libraryPath.normalize().toString());
            logger.log(Level.FINEST, "OpenCV library \"{0}\" loaded from extracted copy at \"{1}\".", new Object[]{Core.NATIVE_LIBRARY_NAME, System.mapLibraryName(Core.NATIVE_LIBRARY_NAME)});
        }

        public static LocalLoader getInstance() {
            return Holder.INSTANCE;
        }

        private static class Holder {
            private static final LocalLoader INSTANCE = new LocalLoader();

            private Holder() {
            }
        }
    }

    private static class SharedLoader {
        private Path libraryPath;

        private SharedLoader() {
            try {
                System.loadLibrary(Core.NATIVE_LIBRARY_NAME);
                logger.log(Level.FINEST, "Loaded existing OpenCV library \"{0}\" from library path.", Core.NATIVE_LIBRARY_NAME);
            }
            catch (UnsatisfiedLinkError ule) {
                if (!String.format("no %s in java.library.path", Core.NATIVE_LIBRARY_NAME).equals(ule.getMessage())) {
                    logger.log(Level.FINEST, String.format("Encountered unexpected loading error.", new Object[0]), ule);
                    throw ule;
                }
                this.libraryPath = OpenCV.extractNativeBinary();
                SharedLoader.addLibraryPath(this.libraryPath.getParent());
                System.loadLibrary(Core.NATIVE_LIBRARY_NAME);
                logger.log(Level.FINEST, "OpenCV library \"{0}\" loaded from extracted copy at \"{1}\".", new Object[]{Core.NATIVE_LIBRARY_NAME, System.mapLibraryName(Core.NATIVE_LIBRARY_NAME)});
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (null == this.libraryPath) {
                return;
            }
            SharedLoader.removeLibraryPath(this.libraryPath.getParent());
        }

        public static SharedLoader getInstance() {
            return Holder.INSTANCE;
        }

        private static void addLibraryPath(Path path) {
            String normalizedPath = path.normalize().toString();
            try {
                Field field = ClassLoader.class.getDeclaredField("usr_paths");
                field.setAccessible(true);
                HashSet<String> userPaths = new HashSet<String>(Arrays.asList((String[])field.get(null)));
                userPaths.add(normalizedPath);
                field.set(null, userPaths.toArray(new String[userPaths.size()]));
                System.setProperty("java.library.path", System.getProperty("java.library.path") + File.pathSeparator + normalizedPath);
                logger.log(Level.FINEST, "System library path now \"{0}\".", System.getProperty("java.library.path"));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to get permissions to set library path");
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Failed to get field handle to set library path");
            }
        }

        private static void removeLibraryPath(Path path) {
            String normalizedPath = path.normalize().toString();
            try {
                Field field = ClassLoader.class.getDeclaredField("usr_paths");
                field.setAccessible(true);
                HashSet<String> userPaths = new HashSet<String>(Arrays.asList((String[])field.get(null)));
                userPaths.remove(normalizedPath);
                field.set(null, userPaths.toArray(new String[userPaths.size()]));
                System.setProperty("java.library.path", System.getProperty("java.library.path").replace(File.pathSeparator + path.normalize().toString(), ""));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to get permissions to set library path");
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Failed to get field handle to set library path");
            }
        }

        private static class Holder {
            private static final SharedLoader INSTANCE = new SharedLoader();

            private Holder() {
            }
        }
    }

    private static class TemporaryDirectory {
        final Path path;

        public TemporaryDirectory() {
            try {
                this.path = Files.createTempDirectory("", new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Path getPath() {
            return this.path;
        }

        public TemporaryDirectory markDeleteOnExit() {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    TemporaryDirectory.this.delete();
                }
            });
            return this;
        }

        public void delete() {
            if (!Files.exists(this.path, new LinkOption[0])) {
                return;
            }
            try {
                Files.walkFileTree(this.path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                        Files.deleteIfExists(dir);
                        return super.postVisitDirectory(dir, e);
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.deleteIfExists(file);
                        return super.visitFile(file, attrs);
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class UnsupportedPlatformException
    extends RuntimeException {
        private UnsupportedPlatformException(OS os, Arch arch) {
            super(String.format("Operating system \"%s\" and architecture \"%s\" are not supported.", new Object[]{os, arch}));
        }
    }

    static enum Arch {
        X86_32("i386", "i686"),
        X86_64("amd64", "x86_64");

        private final Set<String> patterns;

        private Arch(String ... patterns) {
            this.patterns = new HashSet<String>(Arrays.asList(patterns));
        }

        private boolean is(String id) {
            return this.patterns.contains(id);
        }

        public static Arch getCurrent() {
            String osArch = System.getProperty("os.arch");
            for (Arch arch : Arch.values()) {
                if (!arch.is(osArch)) continue;
                logger.log(Level.FINEST, "Current environment matches architecture descriptor \"{0}\".", (Object)arch);
                return arch;
            }
            throw new UnsupportedOperationException(String.format("Architecture \"%s\" is not supported.", osArch));
        }
    }

    static enum OS {
        OSX("^[Mm]ac OS X$"),
        LINUX("^[Ll]inux$"),
        WINDOWS("^[Ww]indows.*");

        private final Set<Pattern> patterns = new HashSet<Pattern>();

        private OS(String ... patterns) {
            for (String pattern : patterns) {
                this.patterns.add(Pattern.compile(pattern));
            }
        }

        private boolean is(String id) {
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(id).matches()) continue;
                return true;
            }
            return false;
        }

        public static OS getCurrent() {
            String osName = System.getProperty("os.name");
            for (OS os : OS.values()) {
                if (!os.is(osName)) continue;
                logger.log(Level.FINEST, "Current environment matches operating system descriptor \"{0}\".", (Object)os);
                return os;
            }
            throw new UnsupportedOperationException(String.format("Operating system \"%s\" is not supported.", osName));
        }
    }
}

