/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.ml;

import org.opencv.core.Mat;
import org.opencv.core.Range;
import org.opencv.ml.CvBoostParams;
import org.opencv.ml.CvStatModel;

public class CvBoost
extends CvStatModel {
    public static final int DISCRETE = 0;
    public static final int REAL = 1;
    public static final int LOGIT = 2;
    public static final int GENTLE = 3;
    public static final int DEFAULT = 0;
    public static final int GINI = 1;
    public static final int MISCLASS = 3;
    public static final int SQERR = 4;

    protected CvBoost(long addr) {
        super(addr);
    }

    public CvBoost() {
        super(CvBoost.CvBoost_0());
    }

    public CvBoost(Mat trainData, int tflag, Mat responses, Mat varIdx, Mat sampleIdx, Mat varType, Mat missingDataMask, CvBoostParams params) {
        super(CvBoost.CvBoost_1(trainData.nativeObj, tflag, responses.nativeObj, varIdx.nativeObj, sampleIdx.nativeObj, varType.nativeObj, missingDataMask.nativeObj, params.nativeObj));
    }

    public CvBoost(Mat trainData, int tflag, Mat responses) {
        super(CvBoost.CvBoost_2(trainData.nativeObj, tflag, responses.nativeObj));
    }

    public void clear() {
        CvBoost.clear_0(this.nativeObj);
    }

    public float predict(Mat sample, Mat missing, Range slice, boolean rawMode, boolean returnSum) {
        float retVal = CvBoost.predict_0(this.nativeObj, sample.nativeObj, missing.nativeObj, slice.start, slice.end, rawMode, returnSum);
        return retVal;
    }

    public float predict(Mat sample) {
        float retVal = CvBoost.predict_1(this.nativeObj, sample.nativeObj);
        return retVal;
    }

    public void prune(Range slice) {
        CvBoost.prune_0(this.nativeObj, slice.start, slice.end);
    }

    public boolean train(Mat trainData, int tflag, Mat responses, Mat varIdx, Mat sampleIdx, Mat varType, Mat missingDataMask, CvBoostParams params, boolean update) {
        boolean retVal = CvBoost.train_0(this.nativeObj, trainData.nativeObj, tflag, responses.nativeObj, varIdx.nativeObj, sampleIdx.nativeObj, varType.nativeObj, missingDataMask.nativeObj, params.nativeObj, update);
        return retVal;
    }

    public boolean train(Mat trainData, int tflag, Mat responses) {
        boolean retVal = CvBoost.train_1(this.nativeObj, trainData.nativeObj, tflag, responses.nativeObj);
        return retVal;
    }

    @Override
    protected void finalize() throws Throwable {
        CvBoost.delete(this.nativeObj);
    }

    private static native long CvBoost_0();

    private static native long CvBoost_1(long var0, int var2, long var3, long var5, long var7, long var9, long var11, long var13);

    private static native long CvBoost_2(long var0, int var2, long var3);

    private static native void clear_0(long var0);

    private static native float predict_0(long var0, long var2, long var4, int var6, int var7, boolean var8, boolean var9);

    private static native float predict_1(long var0, long var2);

    private static native void prune_0(long var0, int var2, int var3);

    private static native boolean train_0(long var0, long var2, int var4, long var5, long var7, long var9, long var11, long var13, long var15, boolean var17);

    private static native boolean train_1(long var0, long var2, int var4, long var5);

    private static native void delete(long var0);
}

