/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.ml;

import org.opencv.core.Algorithm;
import org.opencv.core.Mat;
import org.opencv.core.TermCriteria;

public class EM
extends Algorithm {
    public static final int COV_MAT_SPHERICAL = 0;
    public static final int COV_MAT_DIAGONAL = 1;
    public static final int COV_MAT_GENERIC = 2;
    public static final int COV_MAT_DEFAULT = 1;
    public static final int DEFAULT_NCLUSTERS = 5;
    public static final int DEFAULT_MAX_ITERS = 100;
    public static final int START_E_STEP = 1;
    public static final int START_M_STEP = 2;
    public static final int START_AUTO_STEP = 0;

    protected EM(long addr) {
        super(addr);
    }

    public EM(int nclusters, int covMatType, TermCriteria termCrit) {
        super(EM.EM_0(nclusters, covMatType, termCrit.type, termCrit.maxCount, termCrit.epsilon));
    }

    public EM() {
        super(EM.EM_1());
    }

    public void clear() {
        EM.clear_0(this.nativeObj);
    }

    public boolean isTrained() {
        boolean retVal = EM.isTrained_0(this.nativeObj);
        return retVal;
    }

    public double[] predict(Mat sample, Mat probs) {
        double[] retVal = EM.predict_0(this.nativeObj, sample.nativeObj, probs.nativeObj);
        return retVal;
    }

    public double[] predict(Mat sample) {
        double[] retVal = EM.predict_1(this.nativeObj, sample.nativeObj);
        return retVal;
    }

    public boolean train(Mat samples, Mat logLikelihoods, Mat labels, Mat probs) {
        boolean retVal = EM.train_0(this.nativeObj, samples.nativeObj, logLikelihoods.nativeObj, labels.nativeObj, probs.nativeObj);
        return retVal;
    }

    public boolean train(Mat samples) {
        boolean retVal = EM.train_1(this.nativeObj, samples.nativeObj);
        return retVal;
    }

    public boolean trainE(Mat samples, Mat means0, Mat covs0, Mat weights0, Mat logLikelihoods, Mat labels, Mat probs) {
        boolean retVal = EM.trainE_0(this.nativeObj, samples.nativeObj, means0.nativeObj, covs0.nativeObj, weights0.nativeObj, logLikelihoods.nativeObj, labels.nativeObj, probs.nativeObj);
        return retVal;
    }

    public boolean trainE(Mat samples, Mat means0) {
        boolean retVal = EM.trainE_1(this.nativeObj, samples.nativeObj, means0.nativeObj);
        return retVal;
    }

    public boolean trainM(Mat samples, Mat probs0, Mat logLikelihoods, Mat labels, Mat probs) {
        boolean retVal = EM.trainM_0(this.nativeObj, samples.nativeObj, probs0.nativeObj, logLikelihoods.nativeObj, labels.nativeObj, probs.nativeObj);
        return retVal;
    }

    public boolean trainM(Mat samples, Mat probs0) {
        boolean retVal = EM.trainM_1(this.nativeObj, samples.nativeObj, probs0.nativeObj);
        return retVal;
    }

    @Override
    protected void finalize() throws Throwable {
        EM.delete(this.nativeObj);
    }

    private static native long EM_0(int var0, int var1, int var2, int var3, double var4);

    private static native long EM_1();

    private static native void clear_0(long var0);

    private static native boolean isTrained_0(long var0);

    private static native double[] predict_0(long var0, long var2, long var4);

    private static native double[] predict_1(long var0, long var2);

    private static native boolean train_0(long var0, long var2, long var4, long var6, long var8);

    private static native boolean train_1(long var0, long var2);

    private static native boolean trainE_0(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14);

    private static native boolean trainE_1(long var0, long var2, long var4);

    private static native boolean trainM_0(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native boolean trainM_1(long var0, long var2, long var4);

    private static native void delete(long var0);
}

