/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.features2d;

import java.util.ArrayList;
import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfDMatch;
import org.opencv.core.MatOfKeyPoint;
import org.opencv.utils.Converters;

public class GenericDescriptorMatcher {
    protected final long nativeObj;
    public static final int ONEWAY = 1;
    public static final int FERN = 2;

    protected GenericDescriptorMatcher(long addr) {
        this.nativeObj = addr;
    }

    public void add(List<Mat> images, List<MatOfKeyPoint> keypoints) {
        Mat images_mat = Converters.vector_Mat_to_Mat(images);
        ArrayList<Mat> keypoints_tmplm = new ArrayList<Mat>(keypoints != null ? keypoints.size() : 0);
        Mat keypoints_mat = Converters.vector_vector_KeyPoint_to_Mat(keypoints, keypoints_tmplm);
        GenericDescriptorMatcher.add_0(this.nativeObj, images_mat.nativeObj, keypoints_mat.nativeObj);
    }

    public void classify(Mat queryImage, MatOfKeyPoint queryKeypoints, Mat trainImage, MatOfKeyPoint trainKeypoints) {
        MatOfKeyPoint queryKeypoints_mat = queryKeypoints;
        MatOfKeyPoint trainKeypoints_mat = trainKeypoints;
        GenericDescriptorMatcher.classify_0(this.nativeObj, queryImage.nativeObj, queryKeypoints_mat.nativeObj, trainImage.nativeObj, trainKeypoints_mat.nativeObj);
    }

    public void classify(Mat queryImage, MatOfKeyPoint queryKeypoints) {
        MatOfKeyPoint queryKeypoints_mat = queryKeypoints;
        GenericDescriptorMatcher.classify_1(this.nativeObj, queryImage.nativeObj, queryKeypoints_mat.nativeObj);
    }

    public void clear() {
        GenericDescriptorMatcher.clear_0(this.nativeObj);
    }

    public GenericDescriptorMatcher clone(boolean emptyTrainData) {
        GenericDescriptorMatcher retVal = new GenericDescriptorMatcher(GenericDescriptorMatcher.clone_0(this.nativeObj, emptyTrainData));
        return retVal;
    }

    public GenericDescriptorMatcher clone() {
        GenericDescriptorMatcher retVal = new GenericDescriptorMatcher(GenericDescriptorMatcher.clone_1(this.nativeObj));
        return retVal;
    }

    public static GenericDescriptorMatcher create(int matcherType) {
        GenericDescriptorMatcher retVal = new GenericDescriptorMatcher(GenericDescriptorMatcher.create_0(matcherType));
        return retVal;
    }

    public boolean empty() {
        boolean retVal = GenericDescriptorMatcher.empty_0(this.nativeObj);
        return retVal;
    }

    public List<Mat> getTrainImages() {
        ArrayList<Mat> retVal = new ArrayList<Mat>();
        Mat retValMat = new Mat(GenericDescriptorMatcher.getTrainImages_0(this.nativeObj));
        Converters.Mat_to_vector_Mat(retValMat, retVal);
        return retVal;
    }

    public List<MatOfKeyPoint> getTrainKeypoints() {
        ArrayList<MatOfKeyPoint> retVal = new ArrayList<MatOfKeyPoint>();
        Mat retValMat = new Mat(GenericDescriptorMatcher.getTrainKeypoints_0(this.nativeObj));
        Converters.Mat_to_vector_vector_KeyPoint(retValMat, retVal);
        return retVal;
    }

    public boolean isMaskSupported() {
        boolean retVal = GenericDescriptorMatcher.isMaskSupported_0(this.nativeObj);
        return retVal;
    }

    public void knnMatch(Mat queryImage, MatOfKeyPoint queryKeypoints, Mat trainImage, MatOfKeyPoint trainKeypoints, List<MatOfDMatch> matches, int k, Mat mask, boolean compactResult) {
        MatOfKeyPoint queryKeypoints_mat = queryKeypoints;
        MatOfKeyPoint trainKeypoints_mat = trainKeypoints;
        Mat matches_mat = new Mat();
        GenericDescriptorMatcher.knnMatch_0(this.nativeObj, queryImage.nativeObj, queryKeypoints_mat.nativeObj, trainImage.nativeObj, trainKeypoints_mat.nativeObj, matches_mat.nativeObj, k, mask.nativeObj, compactResult);
        Converters.Mat_to_vector_vector_DMatch(matches_mat, matches);
    }

    public void knnMatch(Mat queryImage, MatOfKeyPoint queryKeypoints, Mat trainImage, MatOfKeyPoint trainKeypoints, List<MatOfDMatch> matches, int k) {
        MatOfKeyPoint queryKeypoints_mat = queryKeypoints;
        MatOfKeyPoint trainKeypoints_mat = trainKeypoints;
        Mat matches_mat = new Mat();
        GenericDescriptorMatcher.knnMatch_1(this.nativeObj, queryImage.nativeObj, queryKeypoints_mat.nativeObj, trainImage.nativeObj, trainKeypoints_mat.nativeObj, matches_mat.nativeObj, k);
        Converters.Mat_to_vector_vector_DMatch(matches_mat, matches);
    }

    public void knnMatch(Mat queryImage, MatOfKeyPoint queryKeypoints, List<MatOfDMatch> matches, int k, List<Mat> masks, boolean compactResult) {
        MatOfKeyPoint queryKeypoints_mat = queryKeypoints;
        Mat matches_mat = new Mat();
        Mat masks_mat = Converters.vector_Mat_to_Mat(masks);
        GenericDescriptorMatcher.knnMatch_2(this.nativeObj, queryImage.nativeObj, queryKeypoints_mat.nativeObj, matches_mat.nativeObj, k, masks_mat.nativeObj, compactResult);
        Converters.Mat_to_vector_vector_DMatch(matches_mat, matches);
    }

    public void knnMatch(Mat queryImage, MatOfKeyPoint queryKeypoints, List<MatOfDMatch> matches, int k) {
        MatOfKeyPoint queryKeypoints_mat = queryKeypoints;
        Mat matches_mat = new Mat();
        GenericDescriptorMatcher.knnMatch_3(this.nativeObj, queryImage.nativeObj, queryKeypoints_mat.nativeObj, matches_mat.nativeObj, k);
        Converters.Mat_to_vector_vector_DMatch(matches_mat, matches);
    }

    public void match(Mat queryImage, MatOfKeyPoint queryKeypoints, Mat trainImage, MatOfKeyPoint trainKeypoints, MatOfDMatch matches, Mat mask) {
        MatOfKeyPoint queryKeypoints_mat = queryKeypoints;
        MatOfKeyPoint trainKeypoints_mat = trainKeypoints;
        MatOfDMatch matches_mat = matches;
        GenericDescriptorMatcher.match_0(this.nativeObj, queryImage.nativeObj, queryKeypoints_mat.nativeObj, trainImage.nativeObj, trainKeypoints_mat.nativeObj, matches_mat.nativeObj, mask.nativeObj);
    }

    public void match(Mat queryImage, MatOfKeyPoint queryKeypoints, Mat trainImage, MatOfKeyPoint trainKeypoints, MatOfDMatch matches) {
        MatOfKeyPoint queryKeypoints_mat = queryKeypoints;
        MatOfKeyPoint trainKeypoints_mat = trainKeypoints;
        MatOfDMatch matches_mat = matches;
        GenericDescriptorMatcher.match_1(this.nativeObj, queryImage.nativeObj, queryKeypoints_mat.nativeObj, trainImage.nativeObj, trainKeypoints_mat.nativeObj, matches_mat.nativeObj);
    }

    public void match(Mat queryImage, MatOfKeyPoint queryKeypoints, MatOfDMatch matches, List<Mat> masks) {
        MatOfKeyPoint queryKeypoints_mat = queryKeypoints;
        MatOfDMatch matches_mat = matches;
        Mat masks_mat = Converters.vector_Mat_to_Mat(masks);
        GenericDescriptorMatcher.match_2(this.nativeObj, queryImage.nativeObj, queryKeypoints_mat.nativeObj, matches_mat.nativeObj, masks_mat.nativeObj);
    }

    public void match(Mat queryImage, MatOfKeyPoint queryKeypoints, MatOfDMatch matches) {
        MatOfKeyPoint queryKeypoints_mat = queryKeypoints;
        MatOfDMatch matches_mat = matches;
        GenericDescriptorMatcher.match_3(this.nativeObj, queryImage.nativeObj, queryKeypoints_mat.nativeObj, matches_mat.nativeObj);
    }

    public void radiusMatch(Mat queryImage, MatOfKeyPoint queryKeypoints, Mat trainImage, MatOfKeyPoint trainKeypoints, List<MatOfDMatch> matches, float maxDistance, Mat mask, boolean compactResult) {
        MatOfKeyPoint queryKeypoints_mat = queryKeypoints;
        MatOfKeyPoint trainKeypoints_mat = trainKeypoints;
        Mat matches_mat = new Mat();
        GenericDescriptorMatcher.radiusMatch_0(this.nativeObj, queryImage.nativeObj, queryKeypoints_mat.nativeObj, trainImage.nativeObj, trainKeypoints_mat.nativeObj, matches_mat.nativeObj, maxDistance, mask.nativeObj, compactResult);
        Converters.Mat_to_vector_vector_DMatch(matches_mat, matches);
    }

    public void radiusMatch(Mat queryImage, MatOfKeyPoint queryKeypoints, Mat trainImage, MatOfKeyPoint trainKeypoints, List<MatOfDMatch> matches, float maxDistance) {
        MatOfKeyPoint queryKeypoints_mat = queryKeypoints;
        MatOfKeyPoint trainKeypoints_mat = trainKeypoints;
        Mat matches_mat = new Mat();
        GenericDescriptorMatcher.radiusMatch_1(this.nativeObj, queryImage.nativeObj, queryKeypoints_mat.nativeObj, trainImage.nativeObj, trainKeypoints_mat.nativeObj, matches_mat.nativeObj, maxDistance);
        Converters.Mat_to_vector_vector_DMatch(matches_mat, matches);
    }

    public void radiusMatch(Mat queryImage, MatOfKeyPoint queryKeypoints, List<MatOfDMatch> matches, float maxDistance, List<Mat> masks, boolean compactResult) {
        MatOfKeyPoint queryKeypoints_mat = queryKeypoints;
        Mat matches_mat = new Mat();
        Mat masks_mat = Converters.vector_Mat_to_Mat(masks);
        GenericDescriptorMatcher.radiusMatch_2(this.nativeObj, queryImage.nativeObj, queryKeypoints_mat.nativeObj, matches_mat.nativeObj, maxDistance, masks_mat.nativeObj, compactResult);
        Converters.Mat_to_vector_vector_DMatch(matches_mat, matches);
    }

    public void radiusMatch(Mat queryImage, MatOfKeyPoint queryKeypoints, List<MatOfDMatch> matches, float maxDistance) {
        MatOfKeyPoint queryKeypoints_mat = queryKeypoints;
        Mat matches_mat = new Mat();
        GenericDescriptorMatcher.radiusMatch_3(this.nativeObj, queryImage.nativeObj, queryKeypoints_mat.nativeObj, matches_mat.nativeObj, maxDistance);
        Converters.Mat_to_vector_vector_DMatch(matches_mat, matches);
    }

    public void read(String fileName) {
        GenericDescriptorMatcher.read_0(this.nativeObj, fileName);
    }

    public void train() {
        GenericDescriptorMatcher.train_0(this.nativeObj);
    }

    public void write(String fileName) {
        GenericDescriptorMatcher.write_0(this.nativeObj, fileName);
    }

    protected void finalize() throws Throwable {
        GenericDescriptorMatcher.delete(this.nativeObj);
    }

    private static native void add_0(long var0, long var2, long var4);

    private static native void classify_0(long var0, long var2, long var4, long var6, long var8);

    private static native void classify_1(long var0, long var2, long var4);

    private static native void clear_0(long var0);

    private static native long clone_0(long var0, boolean var2);

    private static native long clone_1(long var0);

    private static native long create_0(int var0);

    private static native boolean empty_0(long var0);

    private static native long getTrainImages_0(long var0);

    private static native long getTrainKeypoints_0(long var0);

    private static native boolean isMaskSupported_0(long var0);

    private static native void knnMatch_0(long var0, long var2, long var4, long var6, long var8, long var10, int var12, long var13, boolean var15);

    private static native void knnMatch_1(long var0, long var2, long var4, long var6, long var8, long var10, int var12);

    private static native void knnMatch_2(long var0, long var2, long var4, long var6, int var8, long var9, boolean var11);

    private static native void knnMatch_3(long var0, long var2, long var4, long var6, int var8);

    private static native void match_0(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    private static native void match_1(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native void match_2(long var0, long var2, long var4, long var6, long var8);

    private static native void match_3(long var0, long var2, long var4, long var6);

    private static native void radiusMatch_0(long var0, long var2, long var4, long var6, long var8, long var10, float var12, long var13, boolean var15);

    private static native void radiusMatch_1(long var0, long var2, long var4, long var6, long var8, long var10, float var12);

    private static native void radiusMatch_2(long var0, long var2, long var4, long var6, float var8, long var9, boolean var11);

    private static native void radiusMatch_3(long var0, long var2, long var4, long var6, float var8);

    private static native void read_0(long var0, String var2);

    private static native void train_0(long var0);

    private static native void write_0(long var0, String var2);

    private static native void delete(long var0);
}

