/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.ui.framework.search.result;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opennms.smoketest.ui.framework.search.result.ItemType;
import org.opennms.smoketest.ui.framework.search.result.SearchResult;
import org.opennms.smoketest.ui.framework.search.result.SearchResultItem;
import org.openqa.selenium.WebDriver;

public class ContextSearchResult
extends SearchResult {
    private final String context;

    public ContextSearchResult(WebDriver driver, String input, String context) {
        super(driver, input);
        this.context = context;
    }

    @Override
    public List<SearchResultItem> getItems() {
        return this.getItemsByContext().getOrDefault(this.context, new ArrayList());
    }

    public SearchResultItem getItem(String caption) {
        SearchResultItem item = this.getItems().stream().filter(i -> i.getLabel().contains(caption)).findFirst().orElse(null);
        return item;
    }

    public boolean hasMore() {
        Optional<SearchResultItem> moreItem = this.getItems().stream().filter(item -> item.getType() == ItemType.More).findAny();
        return moreItem.isPresent();
    }

    public void loadMore() {
        Optional<SearchResultItem> any = this.getItems().stream().filter(item -> item.getType() == ItemType.More).findAny();
        if (any.isPresent()) {
            any.get().click();
        }
    }

    private Map<String, List<SearchResultItem>> getItemsByContext() {
        String currentContext = null;
        HashMap contextMap = Maps.newHashMap();
        for (SearchResultItem item : super.getItems()) {
            if (item.getType() == ItemType.Header) {
                String context = item.getLabel().endsWith("s") ? item.getLabel().substring(0, item.getLabel().length() - 1) : item.getLabel();
                contextMap.putIfAbsent(context, new ArrayList());
                currentContext = context;
            }
            if (currentContext == null || item.getType() == ItemType.Header) continue;
            ((List)contextMap.get(currentContext)).add(item);
        }
        return contextMap;
    }
}

