/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.telemetry;

import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Objects;

public interface Sender {
    public void send(byte[] var1) throws IOException;

    public static Sender udp(InetSocketAddress destinationAddress) {
        Objects.requireNonNull(destinationAddress);
        return payload -> {
            Objects.requireNonNull(payload);
            try (DatagramSocket serverSocket = new DatagramSocket();){
                DatagramPacket sendPacket = new DatagramPacket(payload, payload.length, destinationAddress);
                serverSocket.send(sendPacket);
            }
        };
    }

    public static Sender tcp(InetSocketAddress destinationAddress) throws IOException {
        Objects.requireNonNull(destinationAddress);
        Socket socket = new Socket();
        socket.connect(destinationAddress);
        return Sender.stream(socket.getOutputStream());
    }

    public static Sender stream(OutputStream stream) {
        return stream::write;
    }
}

