/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.stacks;

import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.opennms.smoketest.stacks.OverlayFile;

public class SentinelProfile {
    public static final SentinelProfile DEFAULT = SentinelProfile.newBuilder().build();
    private final String id;
    private final boolean jvmDebuggingEnabled;
    private final List<OverlayFile> files;

    private SentinelProfile(Builder builder) {
        this.id = builder.id;
        this.jvmDebuggingEnabled = builder.jvmDebuggingEnabled;
        this.files = Collections.unmodifiableList(builder.files);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public boolean isJvmDebuggingEnabled() {
        return this.jvmDebuggingEnabled;
    }

    public List<OverlayFile> getFiles() {
        return this.files;
    }

    public static final class Builder {
        private String id = UUID.randomUUID().toString();
        private boolean jvmDebuggingEnabled = false;
        private List<OverlayFile> files = new LinkedList<OverlayFile>();

        public Builder withFile(Path source, String target) {
            try {
                this.files.add(new OverlayFile(source.toUri().toURL(), target));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder withId(String id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }

        public Builder withJvmDebuggingEnabled(boolean enabled) {
            this.jvmDebuggingEnabled = enabled;
            return this;
        }

        public SentinelProfile build() {
            return new SentinelProfile(this);
        }
    }
}

