/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.utils;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;

public class SyslogUtils {
    public static final String SYSLOG_MESSAGE_UEI = "uei.opennms.org/vendor/cisco/syslog/SEC-6-IPACCESSLOGP/aclDeniedIPTraffic";
    private static final AtomicInteger ORDINAL = new AtomicInteger();

    public static void sendMessage(InetSocketAddress syslogAddr, String host, int eventCount) {
        ArrayList<Integer> randomNumbers = new ArrayList<Integer>();
        for (int i = 0; i < eventCount; ++i) {
            int eventNum = Double.valueOf(Math.random() * 10000.0).intValue();
            randomNumbers.add(eventNum);
        }
        String message = "<190>Mar 11 08:35:17 " + host + " 30128311: Mar 11 08:35:16.844 CST: %SEC-6-IPACCESSLOGP: list in110 denied tcp 192.168.10.100(63923) -> 192.168.11.128(1521), " + ORDINAL.getAndIncrement() + " packet\n";
        HashSet<Integer> sendSizes = new HashSet<Integer>();
        try (DatagramChannel channel = DatagramChannel.open(StandardProtocolFamily.INET);){
            channel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)Integer.MAX_VALUE);
            channel.connect(syslogAddr);
            ByteBuffer buffer = ByteBuffer.allocate(4096);
            buffer.clear();
            for (int i = 0; i < eventCount; ++i) {
                buffer.put(message.getBytes());
                buffer.flip();
                int sent = channel.send(buffer, syslogAddr);
                sendSizes.add(sent);
                buffer.clear();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

