/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.containers;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class MockCloudContainer
extends GenericContainer<MockCloudContainer> {
    public static final String ALIAS = "cloudMock";
    public static final int PORT = 9003;
    private static final Path CLOUD_MOCK_PATH_HOST = Path.of("target/cloud-mock-with-dependencies/org.opennms.plugins.cloud-mock-with-dependencies.jar", new String[0]);
    private static final Path CLOUD_MOCK_PATH_CONTAINER = Path.of("/", new String[0]).resolve(CLOUD_MOCK_PATH_HOST.getFileName());
    private static final String CLOUD_MOCK_MAIN = "org.opennms.plugins.cloud.ittest.MockCloudMain";

    public MockCloudContainer() {
        super(DockerImageName.parse((String)"opennms/deploy-base:ubi9-3.3.1.b265-jre-17"));
        ((MockCloudContainer)((MockCloudContainer)((MockCloudContainer)((MockCloudContainer)this.withCopyFileToContainer(MountableFile.forHostPath((Path)CLOUD_MOCK_PATH_HOST), CLOUD_MOCK_PATH_CONTAINER.toString())).withCommand(new String[]{"/usr/bin/java", "-cp", CLOUD_MOCK_PATH_CONTAINER.toString(), CLOUD_MOCK_MAIN})).withExposedPorts(new Integer[]{9003})).withNetwork(Network.SHARED)).withNetworkAliases(new String[]{ALIAS});
    }

    public static String classpathFileToString(String fileInClasspath) throws IOException {
        URL url = new URL(String.format("jar:file:%s!%s", CLOUD_MOCK_PATH_HOST, fileInClasspath));
        try (InputStream inputStream = url.openStream();){
            String string = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
    }

    public static String createConfig() throws IOException {
        return Joiner.on((char)'\n').join((Object[])new String[]{"config:edit org.opennms.plugins.cloud", String.format("property-set pas.tls.host %s", ALIAS), String.format("property-set pas.tls.port %s", 9003), "property-set pas.tls.security TLS", String.format("property-set pas.mtls.host %s", ALIAS), String.format("property-set pas.mtls.port %s", 9003), "property-set pas.mtls.security MTLS", String.format("property-set grpc.truststore \"%s\"", MockCloudContainer.classpathFileToString("/cert/horizon/servertruststore.pem")), "config:update"});
    }
}

