/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.containers;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.opennms.core.utils.SystemInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.lifecycle.TestDescription;
import org.testcontainers.lifecycle.TestLifecycleAware;

public class JaegerContainer
extends GenericContainer<JaegerContainer>
implements TestLifecycleAware {
    public static final String ALIAS = "jaeger";
    public static final int WEB_PORT = 16686;
    public static final int THRIFT_HTTP_PORT = 14268;
    public static final String IMAGE = "jaegertracing/all-in-one:1.39";
    private static final Logger LOG = LoggerFactory.getLogger(JaegerContainer.class);

    public JaegerContainer() {
        super(IMAGE);
        this.withNetwork(Network.SHARED);
        this.withNetworkAliases(new String[]{ALIAS});
        this.withExposedPorts(new Integer[]{16686});
    }

    public URL getURL(String path) throws MalformedURLException {
        Objects.requireNonNull(path);
        return new URL("http://" + this.getHost() + ":" + this.getMappedPort(16686).toString() + path);
    }

    public static String getThriftHttpURL() {
        return String.format("http://%s:%d/api/traces", ALIAS, 14268);
    }

    public void afterTest(TestDescription description, Optional<Throwable> throwable) {
        this.retainLogsIfNeeded(description.getFilesystemFriendlyName(), !throwable.isPresent());
    }

    private void retainLogsIfNeeded(String prefix, boolean failed) {
        if (failed) {
            try {
                Path opennms = Paths.get("target", "logs", prefix, ALIAS, "opennms-traces.json");
                FileUtils.copyURLToFile((URL)this.getURL("/api/traces?service=" + URLEncoder.encode(SystemInfoUtils.getInstanceId(), Charset.defaultCharset())), (File)opennms.toFile());
                LOG.info("OpenNMS Jaeger trace JSON: {}", (Object)opennms.toUri());
            }
            catch (Exception e) {
                System.err.println("Received exception while trying to save all Jaeger traces");
                e.printStackTrace(System.err);
            }
        }
    }
}

