/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.containers;

import com.github.dockerjava.api.exception.NotFoundException;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.awaitility.Awaitility;
import org.hamcrest.Matchers;
import org.opennms.smoketest.containers.JaegerContainer;
import org.opennms.smoketest.containers.KarafContainer;
import org.opennms.smoketest.stacks.InternetProtocol;
import org.opennms.smoketest.stacks.IpcStrategy;
import org.opennms.smoketest.stacks.NetworkProtocol;
import org.opennms.smoketest.stacks.OpenNMSProfile;
import org.opennms.smoketest.stacks.StackModel;
import org.opennms.smoketest.stacks.TimeSeriesStrategy;
import org.opennms.smoketest.utils.DevDebugUtils;
import org.opennms.smoketest.utils.KarafShellUtils;
import org.opennms.smoketest.utils.OverlayUtils;
import org.opennms.smoketest.utils.RestClient;
import org.opennms.smoketest.utils.RestHealthClient;
import org.opennms.smoketest.utils.SshClient;
import org.opennms.smoketest.utils.TestContainerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.CassandraContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.SelinuxContext;
import org.testcontainers.containers.wait.strategy.AbstractWaitStrategy;
import org.testcontainers.lifecycle.TestDescription;
import org.testcontainers.lifecycle.TestLifecycleAware;

public class OpenNMSContainer
extends GenericContainer<OpenNMSContainer>
implements KarafContainer<OpenNMSContainer>,
TestLifecycleAware {
    public static final String IMAGE = "opennms/horizon";
    public static final String ALIAS = "opennms";
    public static final String DB_ALIAS = "db";
    public static final String KAFKA_ALIAS = "kafka";
    public static final String ELASTIC_ALIAS = "elastic";
    public static final String CASSANDRA_ALIAS = "cassandra";
    public static final String ADMIN_USER = "admin";
    public static final String ADMIN_PASSWORD = "admin";
    public static final Path CONTAINER_LOG_DIR = Paths.get("/opt", "opennms", "logs");
    private static final Logger LOG = LoggerFactory.getLogger(OpenNMSContainer.class);
    public static final int OPENNMS_WEB_PORT = 8980;
    private static final int OPENNMS_SSH_PORT = 8101;
    private static final int OPENNMS_SYSLOG_PORT = 10514;
    private static final int OPENNMS_SNMP_PORT = 1162;
    private static final int OPENNMS_TELEMETRY_FLOW_PORT = 50000;
    private static final int OPENNMS_TELEMETRY_IPFIX_TCP_PORT = 4730;
    private static final int OPENNMS_TELEMETRY_JTI_PORT = 50001;
    private static final int OPENNMS_TELEMETRY_NXOS_PORT = 50002;
    private static final int OPENNMS_DEBUG_PORT = 8001;
    private static final int OPENNMS_GRPC_PORT = 8990;
    private static final int OPENNMS_BMP_PORT = 11019;
    private static final int OPENNMS_TFTP_PORT = 6969;
    private static final boolean COLLECT_COVERAGE = "true".equals(System.getProperty("coverage", "false"));
    private static final Map<NetworkProtocol, Integer> networkProtocolMap = ImmutableMap.builder().put((Object)NetworkProtocol.SSH, (Object)8101).put((Object)NetworkProtocol.HTTP, (Object)8980).put((Object)NetworkProtocol.JDWP, (Object)8001).put((Object)NetworkProtocol.SNMP, (Object)1162).put((Object)NetworkProtocol.SYSLOG, (Object)10514).put((Object)NetworkProtocol.FLOWS, (Object)50000).put((Object)NetworkProtocol.IPFIX_TCP, (Object)4730).put((Object)NetworkProtocol.JTI, (Object)50001).put((Object)NetworkProtocol.NXOS, (Object)50002).put((Object)NetworkProtocol.GRPC, (Object)8990).put((Object)NetworkProtocol.BMP, (Object)11019).put((Object)NetworkProtocol.TFTP, (Object)6969).build();
    private final StackModel model;
    private final OpenNMSProfile profile;
    private final Path overlay;
    private int generatedUserId = -1;
    private Exception afterTestCalled = null;
    private Exception waitUntilReadyException = null;

    public OpenNMSContainer(StackModel model, OpenNMSProfile profile) {
        super(IMAGE);
        this.model = Objects.requireNonNull(model);
        this.profile = Objects.requireNonNull(profile);
        if (model.isSimulateRestricedOpenShiftEnvironment()) {
            this.generatedUserId = ThreadLocalRandom.current().nextInt(1000600000, 1000700001);
        }
        this.overlay = this.writeOverlay();
        String containerCommand = "-s";
        if (TimeSeriesStrategy.NEWTS.equals((Object)model.getTimeSeriesStrategy())) {
            this.withEnv("OPENNMS_TIMESERIES_STRATEGY", model.getTimeSeriesStrategy().name().toLowerCase());
        }
        Integer[] exposedPorts = (Integer[])networkProtocolMap.entrySet().stream().filter(e -> InternetProtocol.TCP.equals((Object)((NetworkProtocol)((Object)((Object)e.getKey()))).getIpProtocol())).map(Map.Entry::getValue).toArray(Integer[]::new);
        int[] exposedUdpPorts = networkProtocolMap.entrySet().stream().filter(e -> InternetProtocol.UDP.equals((Object)((NetworkProtocol)((Object)((Object)e.getKey()))).getIpProtocol())).mapToInt(Map.Entry::getValue).toArray();
        Object javaOpts = "-Xms2048m -Xmx2048m -Djava.security.egd=file:/dev/./urandom";
        if (COLLECT_COVERAGE) {
            javaOpts = (String)javaOpts + " -javaagent:/opt/opennms/agent/jacoco-agent.jar=output=none,jmx=true,excludes=org.drools.*";
        }
        if (profile.isJvmDebuggingEnabled()) {
            javaOpts = (String)javaOpts + String.format(" -agentlib:jdwp=transport=dt_socket,server=y,address=*:%d,suspend=n", 8001);
        }
        if (model.isSimulateRestricedOpenShiftEnvironment()) {
            this.withEnv("JAVA_HOME", "/usr/lib/jvm/java-nocap");
        }
        ((OpenNMSContainer)((OpenNMSContainer)((OpenNMSContainer)((OpenNMSContainer)((OpenNMSContainer)((OpenNMSContainer)((OpenNMSContainer)((OpenNMSContainer)((OpenNMSContainer)((OpenNMSContainer)((OpenNMSContainer)((OpenNMSContainer)((OpenNMSContainer)((OpenNMSContainer)((OpenNMSContainer)((OpenNMSContainer)((OpenNMSContainer)((OpenNMSContainer)this.withExposedPorts(exposedPorts)).withCreateContainerCmdModifier(createCmd -> {
            TestContainerUtils.setGlobalMemAndCpuLimits(createCmd);
            TestContainerUtils.exposePortsAsUdp(createCmd, exposedUdpPorts);
            if (model.isSimulateRestricedOpenShiftEnvironment()) {
                createCmd.withUser(this.generatedUserId + ":0");
            }
        })).withEnv("POSTGRES_HOST", DB_ALIAS)).withEnv("POSTGRES_PORT", Integer.toString(PostgreSQLContainer.POSTGRESQL_PORT))).withEnv("POSTGRES_USER", "test")).withEnv("POSTGRES_PASSWORD", "test")).withEnv("OPENNMS_DBNAME", ALIAS)).withEnv("OPENNMS_DBUSER", ALIAS)).withEnv("OPENNMS_DBPASS", ALIAS)).withEnv("OPENNMS_CASSANDRA_HOSTNAMES", CASSANDRA_ALIAS)).withEnv("OPENNMS_CASSANDRA_KEYSPACE", "newts")).withEnv("OPENNMS_CASSANDRA_PORT", Integer.toString(CassandraContainer.CQL_PORT))).withEnv("OPENNMS_CASSANDRA_USERNAME", CASSANDRA_ALIAS)).withEnv("OPENNMS_CASSANDRA_USERNAME", CASSANDRA_ALIAS)).withEnv("JAVA_OPTS", (String)javaOpts)).withNetwork(Network.SHARED)).withNetworkAliases(new String[]{ALIAS})).withCommand(containerCommand)).waitingFor(Objects.requireNonNull(profile.getWaitStrategy()).apply(this));
        this.addFileSystemBind(this.overlay.toString(), "/opt/opennms-overlay", BindMode.READ_ONLY, SelinuxContext.SINGLE);
        for (Map.Entry<String, Path> installFeature : profile.getInstallFeatures().entrySet()) {
            if (installFeature.getValue() == null) continue;
            this.addFileSystemBind(installFeature.getValue().toString(), "/opt/opennms/deploy/" + installFeature.getValue().getFileName(), BindMode.READ_ONLY, SelinuxContext.SINGLE);
        }
        DevDebugUtils.setupMavenRepoBind(this, "/root/.m2/repository");
    }

    private Path writeOverlay() {
        try {
            Path home = Files.createTempDirectory(ALIAS, new FileAttribute[0]).toAbsolutePath();
            this.writeOverlay(home);
            return home;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeOverlay(Path home) throws IOException {
        OverlayUtils.setOverlayPermissions(home);
        OverlayUtils.copyFiles(this.profile.getFiles(), home);
        OverlayUtils.copyAndTemplate("opennms-overlay", home, this.model);
        Path etc = home.resolve("etc");
        Path propsD = etc.resolve("opennms.properties.d");
        Files.createDirectories(propsD, new FileAttribute[0]);
        Properties sysProps = this.getSystemProperties();
        File propsFile = propsD.resolve("stest.properties").toFile();
        try (FileOutputStream fos = new FileOutputStream(propsFile);){
            sysProps.store(fos, "Generated");
        }
        if (this.model.isSimulateRestricedOpenShiftEnvironment()) {
            OverlayUtils.writeProps(etc.resolve("opennms.conf"), (Map<String, String>)ImmutableMap.builder().put((Object)"RUNAS", (Object)Integer.toString(this.generatedUserId)).build());
        }
        Path bootD = etc.resolve("featuresBoot.d");
        Files.createDirectories(bootD, new FileAttribute[0]);
        OverlayUtils.writeFeaturesBoot(bootD.resolve("stest.boot"), this.getFeaturesOnBoot());
        if (this.model.isElasticsearchEnabled()) {
            OverlayUtils.writeProps(etc.resolve("org.opennms.features.flows.persistence.elastic.cfg"), (Map<String, String>)ImmutableMap.builder().put((Object)"elasticUrl", (Object)"http://elastic:9200").build());
            OverlayUtils.writeProps(etc.resolve("org.opennms.plugin.elasticsearch.rest.forwarder.cfg"), (Map<String, String>)ImmutableMap.builder().put((Object)"elasticUrl", (Object)"http://elastic:9200").put((Object)"logAllEvents", (Object)Boolean.TRUE.toString()).put((Object)"batchSize", (Object)Integer.toString(500)).put((Object)"batchInterval", (Object)Integer.toString(500)).put((Object)"connTimeout", (Object)Integer.toString(5000)).put((Object)"retries", (Object)Integer.toString(10)).build());
            OverlayUtils.writeProps(etc.resolve("org.opennms.features.alarms.history.elastic.cfg"), (Map<String, String>)ImmutableMap.builder().put((Object)"elasticUrl", (Object)"http://elastic:9200").build());
        }
        if (this.model.getOpenNMS().isKafkaProducerEnabled()) {
            OverlayUtils.writeProps(etc.resolve("org.opennms.features.kafka.producer.client.cfg"), (Map<String, String>)ImmutableMap.builder().put((Object)"bootstrap.servers", (Object)"kafka:9092").put((Object)"compression.type", (Object)this.model.getKafkaCompressionStrategy().getCodec()).build());
            OverlayUtils.writeProps(etc.resolve("org.opennms.features.kafka.producer.cfg"), (Map<String, String>)ImmutableMap.builder().put((Object)"forward.metrics", (Object)Boolean.TRUE.toString()).put((Object)"compression.type", (Object)this.model.getKafkaCompressionStrategy().getCodec()).build());
        }
    }

    public URL getBaseUrlInternal() {
        try {
            return new URL(String.format("http://%s:%d/", ALIAS, 8980));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public URL getBaseUrlExternal() {
        try {
            return new URL(String.format("http://%s:%d/", this.getContainerIpAddress(), this.getMappedPort(8980)));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public URL getWebUrl() {
        return this.getBaseUrlExternal();
    }

    public RestClient getRestClient() {
        try {
            return new RestClient(new URL(this.getBaseUrlExternal() + ALIAS));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InetSocketAddress getSshAddress() {
        return InetSocketAddress.createUnresolved(this.getContainerIpAddress(), this.getMappedPort(8101));
    }

    @Override
    public SshClient ssh() {
        return new SshClient(this.getSshAddress(), "admin", "admin");
    }

    @Override
    public Path getKarafHomeDirectory() {
        return Path.of("/opt/opennms", new String[0]);
    }

    public int getWebPort() {
        return this.getMappedPort(8980);
    }

    public InetSocketAddress getWebAddress() {
        return InetSocketAddress.createUnresolved(this.getContainerIpAddress(), this.getMappedPort(8980));
    }

    public Properties getSystemProperties() {
        Properties props = new Properties();
        if (IpcStrategy.KAFKA.equals((Object)this.model.getIpcStrategy())) {
            props.put("org.opennms.core.ipc.strategy", KAFKA_ALIAS);
            props.put("org.opennms.core.ipc.kafka.bootstrap.servers", "kafka:9092");
            props.put("org.opennms.core.ipc.kafka.compression.type", this.model.getKafkaCompressionStrategy().getCodec());
        }
        if (IpcStrategy.GRPC.equals((Object)this.model.getIpcStrategy())) {
            props.put("org.opennms.core.ipc.strategy", "osgi");
        }
        if (TimeSeriesStrategy.RRD.equals((Object)this.model.getTimeSeriesStrategy())) {
            props.put("org.opennms.rrd.strategyClass", "org.opennms.netmgt.rrd.rrdtool.MultithreadedJniRrdStrategy");
            props.put("org.opennms.rrd.interfaceJar", "/usr/share/java/jrrd2.jar");
            props.put("opennms.library.jrrd2", "/usr/lib/jni/libjrrd2.so");
        } else if (TimeSeriesStrategy.NEWTS.equals((Object)this.model.getTimeSeriesStrategy())) {
            props.put("org.opennms.timeseries.strategy", "newts");
            props.put("org.opennms.newts.config.hostname", CASSANDRA_ALIAS);
            props.put("org.opennms.newts.config.port", Integer.toString(CassandraContainer.CQL_PORT));
            props.put("org.opennms.rrd.storeByForeignSource", Boolean.TRUE.toString());
        }
        if (this.model.isJaegerEnabled()) {
            props.put("org.opennms.core.tracer", "jaeger");
            props.put("JAEGER_ENDPOINT", JaegerContainer.getThriftHttpURL());
        }
        props.put("opennms.productUpdateEnrollment.show", "false");
        props.put("karaf.log.console", "INFO");
        return props;
    }

    public List<String> getFeaturesOnBoot() {
        ArrayList<String> featuresOnBoot = new ArrayList<String>();
        for (Map.Entry<String, Path> installFeature : this.profile.getInstallFeatures().entrySet()) {
            featuresOnBoot.add(installFeature.getKey());
        }
        if (IpcStrategy.GRPC.equals((Object)this.model.getIpcStrategy())) {
            featuresOnBoot.add("opennms-core-ipc-grpc-server");
        }
        if (this.model.isElasticsearchEnabled()) {
            featuresOnBoot.add("opennms-es-rest");
        }
        if (this.profile.isKafkaProducerEnabled()) {
            featuresOnBoot.add("opennms-kafka-producer");
        }
        if (this.model.isJaegerEnabled()) {
            featuresOnBoot.add("opennms-core-tracing-jaeger");
        }
        return featuresOnBoot;
    }

    public InetSocketAddress getNetworkProtocolAddress(NetworkProtocol protocol) {
        Integer port = networkProtocolMap.get((Object)protocol);
        if (port == null) {
            throw new IllegalArgumentException("No known port mapping for: " + protocol);
        }
        int mappedPort = InternetProtocol.UDP.equals((Object)protocol.getIpProtocol()) ? TestContainerUtils.getMappedUdpPort(this, port) : this.getMappedPort(port);
        return new InetSocketAddress(this.getContainerIpAddress(), mappedPort);
    }

    public StackModel getModel() {
        return this.model;
    }

    public int getGeneratedUserId() {
        return this.generatedUserId;
    }

    public void afterTest(TestDescription description, Optional<Throwable> throwable) {
        long pid = ProcessHandle.current().pid();
        if (this.afterTestCalled != null) {
            LOG.warn("afterTest has already been called, not running on subsequent calls. My PID {}.", (Object)pid, (Object)new Exception("exception placeholder for stacktrace -- subsequent call location of afterTest"));
            LOG.warn("original call location of afterTest", (Throwable)this.afterTestCalled);
            return;
        }
        this.afterTestCalled = new Exception("exception placeholder for stacktrace -- original call location of afterTest; PID: " + pid);
        if (COLLECT_COVERAGE) {
            KarafShellUtils.saveCoverage(this, description.getFilesystemFriendlyName(), ALIAS);
        }
        this.retainLogsfNeeded(description.getFilesystemFriendlyName(), !throwable.isPresent());
    }

    private void retainLogsfNeeded(String prefix, boolean succeeded) {
        List<String> logFiles = Arrays.asList("alarmd.log", "collectd.log", "eventd.log", "jetty-server.log", "karaf.log", "manager.log", "poller.log", "provisiond.log", "telemetryd.log", "trapd.log", "web.log");
        Path targetLogFolder = Paths.get("target", "logs", prefix, ALIAS);
        DevDebugUtils.clearLogs(targetLogFolder);
        AtomicReference threadDump = new AtomicReference();
        Awaitility.await((String)"calling gatherThreadDump").atMost(Duration.ofSeconds(120L)).untilAsserted(() -> threadDump.set(DevDebugUtils.gatherThreadDump(this, targetLogFolder, null)));
        LOG.info("Gathering logs...");
        DevDebugUtils.copyLogs(this, targetLogFolder, CONTAINER_LOG_DIR, logFiles);
        LOG.info("Log directory: {}", (Object)targetLogFolder.toUri());
        LOG.info("Console log: {}", (Object)targetLogFolder.resolve("container_stdout_stderr").toUri());
        LOG.info("Output log: {}", (Object)targetLogFolder.resolve("output.log").toUri());
        if (threadDump.get() != null) {
            LOG.info("Thread dump: {}", (Object)((Path)threadDump.get()).toUri());
        }
    }

    public static class WaitForOpenNMS
    extends AbstractWaitStrategy {
        private final OpenNMSContainer container;

        public WaitForOpenNMS(OpenNMSContainer container) {
            this.container = Objects.requireNonNull(container);
        }

        protected void waitUntilReady() {
            try {
                this.waitUntilReadyWrapped();
            }
            catch (Exception e) {
                String logs = "\n\t\t----------------------------------------------------------\n" + this.container.getLogs().replaceFirst("(?ms).*?(^An error occurred while attempting to start the .*?)\\s*^\\[INFO\\].*", "$1\n").replaceAll("(?m)^", "\t\t") + "\t\t----------------------------------------------------------";
                throw e;
            }
        }

        protected void waitUntilReadyWrapped() {
            LOG.info("Waiting for startup to begin.");
            Path managerLog = CONTAINER_LOG_DIR.resolve("manager.log");
            Awaitility.await((String)"waiting for startup to begin").atMost(3L, TimeUnit.MINUTES).failFast("container is no longer running", () -> !this.container.isRunning()).ignoreException(NotFoundException.class).until(() -> TestContainerUtils.getFileFromContainerAsString(this.container, managerLog), Matchers.containsString((String)"Starter: Beginning startup"));
            LOG.info("OpenNMS has begun starting up.");
            LOG.info("Waiting for OpenNMS REST API...");
            long timeoutMins = 5L;
            RestClient restClient = this.container.getRestClient();
            Awaitility.await((String)"waiting for OpenNMS REST API").atMost(5L, TimeUnit.MINUTES).pollInterval(10L, TimeUnit.SECONDS).failFast("container is no longer running", () -> !this.container.isRunning()).ignoreExceptionsMatching(e -> e.getCause() != null && e.getCause() instanceof SocketException).until(restClient::getDisplayVersion, Matchers.notNullValue());
            LOG.info("OpenNMS REST API is online.");
            LOG.info("Waiting for startup to complete.");
            Awaitility.await((String)"waiting for startup to complete").atMost(5L, TimeUnit.MINUTES).failFast("container is no longer running", () -> !this.container.isRunning()).until(() -> TestContainerUtils.getFileFromContainerAsString(this.container, managerLog), Matchers.containsString((String)"Starter: Startup complete"));
            LOG.info("OpenNMS has started.");
            LOG.info("Waiting for OpenNMS health check...");
            RestHealthClient client = new RestHealthClient(this.container.getWebUrl(), Optional.of(OpenNMSContainer.ALIAS));
            Awaitility.await((String)"waiting for good health check probe").atMost(5L, TimeUnit.MINUTES).pollInterval(10L, TimeUnit.SECONDS).failFast("container is no longer running", () -> !this.container.isRunning()).ignoreExceptionsMatching(e -> e.getCause() != null && e.getCause() instanceof SocketException).until(client::getProbeHealthResponse, Matchers.containsString((String)client.getProbeSuccessMessage()));
            LOG.info("Health check passed.");
            this.container.assertNoKarafDestroy(Paths.get("/opt", OpenNMSContainer.ALIAS, "logs", "karaf.log"));
        }
    }
}

