/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.utils;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.opennms.smoketest.utils.StreamGobbler;
import org.opennms.smoketest.utils.jsch.SLF4JLogger;
import org.slf4j.LoggerFactory;

public class SshClient
implements AutoCloseable {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(SshClient.class);
    private static final Logger jschLogger = new SLF4JLogger();
    public static final int DEFAULT_TIMEOUT_MS = 5000;
    private final JSch jsch;
    private Session session;
    private Channel channel;
    private PrintStream stdin;
    private InputStream stdout;
    private InputStream stderr;
    private final StringBuffer stdoutBuff;
    private final StringBuffer stderrBuff;
    private final InetSocketAddress addr;
    private final String username;
    private final String password;
    private int timeout;

    public SshClient(InetSocketAddress addr, String username, String password) {
        JSch.setLogger((Logger)jschLogger);
        this.jsch = new JSch();
        this.stdoutBuff = new StringBuffer();
        this.stderrBuff = new StringBuffer();
        this.timeout = 5000;
        this.addr = Objects.requireNonNull(addr);
        this.username = username;
        this.password = password;
    }

    public PrintStream openShell() throws Exception {
        this.close();
        this.session = this.jsch.getSession(this.username, this.addr.getHostString(), this.addr.getPort());
        this.session.setPassword(this.password.getBytes());
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        this.session.setConfig(config);
        this.session.connect();
        this.channel = this.session.openChannel("shell");
        ((ChannelShell)this.channel).setPtySize(500, 100, 1920, 1080);
        this.stdout = this.channel.getInputStream();
        this.stderr = this.channel.getExtInputStream();
        this.channel.connect(this.timeout);
        OutputStream ops = this.channel.getOutputStream();
        this.stdin = new PrintStream(ops, true);
        return this.stdin;
    }

    public String getStdout() throws IOException {
        String stdoutContents = this.stdoutBuff.toString() + SshClient.readAvailableBytes(this.stdout);
        this.stdoutBuff.setLength(0);
        return stdoutContents;
    }

    public String getStdoutOrNull() {
        try {
            return this.getStdout();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getStderr() throws IOException {
        String stderrContents = this.stderrBuff.toString() + SshClient.readAvailableBytes(this.stderr);
        this.stderrBuff.setLength(0);
        return stderrContents;
    }

    public void setTimeout(int timeoutInMs) {
        this.timeout = timeoutInMs;
    }

    public InetSocketAddress getAddr() {
        return this.addr;
    }

    @Override
    public void close() throws Exception {
        if (this.channel != null) {
            this.channel.disconnect();
            this.channel = null;
        }
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
        }
    }

    public boolean isShellClosed() {
        if (this.channel == null) {
            return true;
        }
        try {
            this.stdoutBuff.append(this.getStdout());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.stderrBuff.append(this.getStderr());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.channel.isClosed();
    }

    public Streams getStreams() {
        return new Streams(this.stdin, new StreamGobbler(this.stdout, "stdout"), new StreamGobbler(this.stderr, "stderr"));
    }

    private static String readAvailableBytes(InputStream is) throws IOException {
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int BUF_LEN = 1024;
        byte[] buffer = new byte[1024];
        int avail = 0;
        while ((avail = is.available()) > 0) {
            int length = is.read(buffer, 0, Math.min(1024, avail));
            baos.write(buffer, 0, length);
        }
        return baos.toString("UTF-8");
    }

    public Callable<Boolean> isShellClosedCallable() {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return SshClient.this.isShellClosed();
            }
        };
    }

    public static Callable<Boolean> canConnectViaSsh(final InetSocketAddress addr, final String username, final String password) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Boolean bl;
                LOG.info("Attempting to SSH to {}@{}:{}", new Object[]{username, addr.getHostString(), addr.getPort()});
                SshClient client = new SshClient(addr, username, password);
                try {
                    client.setTimeout(1000);
                    client.openShell();
                    bl = true;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        LOG.debug("SSH connection failed: " + t.getMessage());
                        return false;
                    }
                }
                client.close();
                return bl;
            }
        };
    }

    public static class Streams {
        public final PrintStream stdin;
        public final StreamGobbler stdout;
        public final StreamGobbler stderr;

        public Streams(PrintStream stdin, StreamGobbler stdout, StreamGobbler stderr) {
            this.stdin = stdin;
            this.stdout = stdout;
            this.stderr = stderr;
        }
    }
}

