/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.selenium;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.opennms.smoketest.selenium.ExpectedConditions;
import org.opennms.smoketest.selenium.OpenNMSTestException;
import org.opennms.smoketest.selenium.ResponseData;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class AbstractOpenNMSSeleniumHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractOpenNMSSeleniumHelper.class);
    public static final long LOAD_TIMEOUT = Long.getLong("org.opennms.smoketest.web-timeout", 120000L);
    public static final long REQ_TIMEOUT = Long.getLong("org.opennms.smoketest.requisition-timeout", 240000L);
    public static final String BASIC_AUTH_USERNAME = "admin";
    public static final String BASIC_AUTH_PASSWORD = "admin";
    public static final String REQUISITION_NAME = "SeleniumTestGroup";
    public static final String USER_NAME = "SmokeTestUser";
    public static final String GROUP_NAME = "SmokeTestGroup";
    public static final File DOWNLOADS_FOLDER = new File("target/downloads");
    public WebDriverWait wait = null;
    public WebDriverWait requisitionWait = null;
    @Rule
    public TestWatcher m_watcher = new TestWatcher(){

        protected void starting(Description description) {
            LOG.debug("Using driver: {}", (Object)AbstractOpenNMSSeleniumHelper.this.getDriver());
            try {
                AbstractOpenNMSSeleniumHelper.this.setImplicitWait();
            }
            catch (WebDriverException e) {
                e.printStackTrace();
            }
            AbstractOpenNMSSeleniumHelper.this.getDriver().manage().window().setPosition(new Point(0, 0));
            AbstractOpenNMSSeleniumHelper.this.getDriver().manage().window().maximize();
            AbstractOpenNMSSeleniumHelper.this.wait = new WebDriverWait(AbstractOpenNMSSeleniumHelper.this.getDriver(), Duration.ofMillis(LOAD_TIMEOUT));
            AbstractOpenNMSSeleniumHelper.this.requisitionWait = new WebDriverWait(AbstractOpenNMSSeleniumHelper.this.getDriver(), Duration.ofMillis(REQ_TIMEOUT));
            AbstractOpenNMSSeleniumHelper.this.login();
            this.cleanUp();
        }

        protected void failed(Throwable e, Description description) {
            String testName = description.getMethodName();
            WebDriver driver = AbstractOpenNMSSeleniumHelper.this.getDriver();
            if (driver == null) {
                LOG.warn("Test {} failed... no web driver was set.", (Object)testName);
                return;
            }
            LOG.debug("Test {} failed... attempting to take screenshot.", (Object)testName);
            driver.manage().timeouts().implicitlyWait(5L, TimeUnit.SECONDS);
            if (driver instanceof TakesScreenshot) {
                TakesScreenshot shot = (TakesScreenshot)driver;
                try {
                    Path from = ((File)shot.getScreenshotAs(OutputType.FILE)).toPath();
                    Path to = Paths.get("target", "screenshots", description.getClassName() + "." + testName + ".png");
                    LOG.debug("Screenshot saved to: {}", (Object)from);
                    try {
                        Files.createDirectories(to.getParent(), new FileAttribute[0]);
                        Files.move(from, to, StandardCopyOption.REPLACE_EXISTING);
                        LOG.debug("Screenshot moved to: {}", (Object)to);
                    }
                    catch (IOException ioe) {
                        LOG.debug("Failed to move screenshot from {} to {}", new Object[]{from, to, ioe});
                    }
                }
                catch (Exception sse) {
                    LOG.debug("Failed to take screenshot.", (Throwable)sse);
                }
            } else {
                LOG.debug("Driver can't take screenshots.");
            }
            try {
                LOG.debug("Attempting to dump DOM.");
                String domText = driver.findElement(By.tagName((String)"html")).getAttribute("innerHTML");
                Path to = Paths.get("target", "contents", description.getClassName() + "." + testName + ".html");
                try {
                    Files.createDirectories(to.getParent(), new FileAttribute[0]);
                    Files.write(to, domText.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    LOG.debug("Wrote DOM to {}", (Object)to);
                }
                catch (Exception eDOMfile) {
                    LOG.warn("Failed to dump DOM to {}", (Object)to, (Object)eDOMfile);
                }
            }
            catch (Exception eDOM) {
                LOG.debug("Failed to dump DOM: {}", (Object)eDOM.getMessage(), (Object)eDOM);
            }
            LOG.debug("Current URL: {}", (Object)AbstractOpenNMSSeleniumHelper.this.getDriver().getCurrentUrl());
        }

        protected void finished(Description description) {
            this.cleanUp();
        }

        protected void cleanUp() {
            try {
                AbstractOpenNMSSeleniumHelper.this.deleteTestRequisition();
                AbstractOpenNMSSeleniumHelper.this.deleteTestUser();
                AbstractOpenNMSSeleniumHelper.this.deleteTestGroup();
            }
            catch (Exception e) {
                LOG.error("Cleaning up failed. Future tests will be in an unhandled state.", (Throwable)e);
            }
        }
    };

    public abstract WebDriver getDriver();

    public abstract String getBaseUrlInternal();

    public abstract String getBaseUrlExternal();

    public WebDriver.Timeouts setImplicitWait() {
        return this.setImplicitWait(LOAD_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public WebDriver.Timeouts setImplicitWait(long time, TimeUnit unit) {
        LOG.trace("Setting implicit wait to {} milliseconds.", (Object)unit.toMillis(time));
        return this.getDriver().manage().timeouts().implicitlyWait(time, unit);
    }

    protected WebDriverWait waitFor(long seconds) {
        return new WebDriverWait(this.getDriver(), Duration.ofSeconds(seconds));
    }

    protected void waitForClose(final By selector) {
        LOG.debug("waitForClose: {}", (Object)selector);
        try {
            this.setImplicitWait(1L, TimeUnit.SECONDS);
            this.wait.until((Function)new ExpectedCondition<Boolean>(){

                public Boolean apply(WebDriver input) {
                    try {
                        AbstractOpenNMSSeleniumHelper.this.sleepQuietly(200);
                        List elements = input.findElements(selector);
                        if (elements.size() == 0) {
                            return true;
                        }
                        LOG.debug("waitForClose: matching elements: {}", (Object)elements);
                        WebElement element = input.findElement(selector);
                        Point location = element.getLocation();
                        element = input.findElement(selector);
                        Dimension size = element.getSize();
                        if (new Point(0, 0).equals((Object)location) && new Dimension(0, 0).equals((Object)size)) {
                            LOG.debug("waitForClose: {} element technically exists, but is sized 0,0", (Object)element);
                            return true;
                        }
                        LOG.debug("waitForClose: {} element still exists at location {} with size {}: {}", new Object[]{selector, location, size, element.getText()});
                        return false;
                    }
                    catch (NoSuchElementException | StaleElementReferenceException e) {
                        return true;
                    }
                    catch (Exception e) {
                        LOG.debug("waitForClose: unknown exception", (Throwable)e);
                        throw new OpenNMSTestException(e);
                    }
                }
            });
        }
        finally {
            this.setImplicitWait();
        }
    }

    public void login() {
        this.getDriver().manage().deleteAllCookies();
        this.getDriver().get(this.getBaseUrlInternal() + "opennms/login.jsp");
        this.waitForLogin();
        this.enterText(By.name((String)"j_username"), "admin");
        this.enterText(By.name((String)"j_password"), "admin");
        this.clickElement(By.name((String)"Login"));
        this.wait.until(driver -> !driver.getCurrentUrl().contains("login.jsp"));
        this.wait.until((Function)org.openqa.selenium.support.ui.ExpectedConditions.visibilityOfElementLocated((By)By.xpath((String)"//div[@id='content']")));
        this.invokeWithImplicitWait(0, () -> {
            try {
                this.findElementById("login-attempt-failed");
                Assert.fail((String)("Login failed: " + this.findElementById("login-attempt-failed-reason").getText()));
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        });
        this.invokeWithImplicitWait(0, () -> {
            try {
                WebElement element = this.findElementById("usage-statistics-sharing-modal");
                if (element.isDisplayed()) {
                    this.findElementById("usage-statistics-sharing-notice-dismiss").click();
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        });
    }

    private void invokeWithImplicitWait(int implicitWait, Runnable runnable) {
        Objects.requireNonNull(runnable);
        try {
            this.setImplicitWait(Math.max(0, implicitWait), TimeUnit.MILLISECONDS);
            runnable.run();
        }
        finally {
            this.setImplicitWait();
        }
    }

    protected void logout() {
        this.getElementWithoutWaiting(By.name((String)"headerLogoutForm")).submit();
        this.waitForLogin();
    }

    private void waitForLogin() {
        this.wait.until((Function)org.openqa.selenium.support.ui.ExpectedConditions.visibilityOfElementLocated((By)By.name((String)"j_username")));
        this.wait.until((Function)org.openqa.selenium.support.ui.ExpectedConditions.visibilityOfElementLocated((By)By.name((String)"j_password")));
        this.wait.until((Function)org.openqa.selenium.support.ui.ExpectedConditions.elementToBeClickable((By)By.name((String)"Login")));
    }

    protected ExpectedCondition<Boolean> pageContainsText(String text) {
        return ExpectedConditions.pageContainsText(text);
    }

    public void focusElement(By by) {
        this.sleepQuietly(200);
        this.waitForElement(by).click();
    }

    public void clearElement(By by) {
        this.sleepQuietly(200);
        this.waitForElement(by).clear();
    }

    public void assertElementDoesNotExist(By by) {
        LOG.debug("assertElementDoesNotExist: {}", (Object)by);
        WebElement element = this.getElementWithoutWaiting(by);
        if (element == null) {
            LOG.debug("Success: element does not exist: {}", (Object)by);
            return;
        }
        throw new OpenNMSTestException("Element should not exist, but was found: " + element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement getElementImmediately(By by) {
        WebElement element = null;
        try {
            this.setImplicitWait(0L, TimeUnit.MILLISECONDS);
            element = this.getDriver().findElement(by);
        }
        catch (NoSuchElementException e) {
            WebElement webElement = null;
            return webElement;
        }
        finally {
            this.setImplicitWait();
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebElement getElementWithoutWaiting(By by) {
        WebElement element = null;
        try {
            this.setImplicitWait(2L, TimeUnit.SECONDS);
            element = this.getDriver().findElement(by);
        }
        catch (NoSuchElementException e) {
            WebElement webElement = null;
            return webElement;
        }
        finally {
            this.setImplicitWait();
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertElementDoesNotHaveText(By by, String text) {
        LOG.debug("assertElementDoesNotHaveText: locator={}, text={}", (Object)by, (Object)text);
        WebElement element = null;
        try {
            this.setImplicitWait(2L, TimeUnit.SECONDS);
            element = this.getDriver().findElement(by);
            Assert.assertTrue((!element.getText().contains(text) ? 1 : 0) != 0);
        }
        catch (NoSuchElementException e) {
            LOG.debug("Success: element does not exist: {}", (Object)by);
            return;
        }
        finally {
            this.setImplicitWait();
        }
    }

    protected void assertElementHasText(By by, String text) {
        LOG.debug("assertElementHasText: locator={}, text={}", (Object)by, (Object)text);
        WebElement element = this.waitForElement(by);
        Assert.assertTrue((boolean)element.getText().contains(text));
    }

    protected String handleAlert() {
        return this.handleAlert(null);
    }

    protected String handleAlert(String expectedText) {
        LOG.debug("handleAlerm: expectedText={}", (Object)expectedText);
        try {
            Alert alert = this.getDriver().switchTo().alert();
            String alertText = alert.getText();
            if (expectedText != null) {
                Assert.assertEquals((Object)expectedText, (Object)alertText);
            }
            alert.dismiss();
            return alertText;
        }
        catch (NoAlertPresentException e) {
            LOG.debug("handleAlert: no alert is active");
        }
        catch (TimeoutException e) {
            LOG.debug("handleAlert: no alert was found");
        }
        return null;
    }

    protected void setChecked(By by) {
        LOG.debug("setChecked: locator={}", (Object)by);
        WebElement element = this.scrollToElement(by);
        if (element.isSelected()) {
            return;
        }
        element.click();
    }

    protected void setUnchecked(By by) {
        LOG.debug("setUnchecked: locator={}", (Object)by);
        WebElement element = this.scrollToElement(by);
        if (!element.isSelected()) {
            return;
        }
        element.click();
    }

    protected void clickMenuItem(String menuItemText, String submenuItemText, String submenuItemHref) {
        this.clickMenuItem(menuItemText, submenuItemText, submenuItemHref, 30);
    }

    protected void clickMenuItem(String menuItemText, String submenuItemText, String submenuItemHref, int timeout) {
        LOG.debug("clickMenuItem: itemText={}, submenuItemText={}, submenuHref={}, timeout={}", new Object[]{menuItemText, submenuItemText, submenuItemHref, timeout});
        if (timeout == 0) {
            timeout = 30;
        }
        AtomicInteger offset = new AtomicInteger(10);
        WebDriverWait shortWait = new WebDriverWait(this.getDriver(), Duration.ofSeconds(1L));
        Unreliables.retryUntilSuccess((int)timeout, (TimeUnit)TimeUnit.SECONDS, () -> {
            WebElement menuElement;
            Actions action = new Actions(this.getDriver());
            if (menuItemText.startsWith("name=")) {
                String menuItemName = menuItemText.replaceFirst("name=", "");
                menuElement = this.findElementByName(menuItemName);
            } else {
                menuElement = this.findElementByXpath("//a[contains(text(), '" + menuItemText + "')]");
            }
            action.moveToElement(menuElement, offset.get(), offset.get()).perform();
            if (offset.incrementAndGet() > 10) {
                offset.set(0);
            }
            WebElement submenuElement = submenuItemText != null ? (submenuItemHref == null ? this.findElementByXpath("//a[contains(text(), '" + submenuItemText + "')]") : this.findElementByXpath("//a[contains(@href, '" + submenuItemHref + "') and contains(text(), '" + submenuItemText + "')]")) : null;
            if (submenuElement == null) {
                shortWait.until((Function)org.openqa.selenium.support.ui.ExpectedConditions.visibilityOf((WebElement)menuElement));
                menuElement.click();
            } else {
                shortWait.until((Function)org.openqa.selenium.support.ui.ExpectedConditions.visibilityOf((WebElement)submenuElement));
                submenuElement.click();
            }
            return null;
        });
    }

    protected void frontPage() {
        LOG.debug("navigating to the front page");
        this.getDriver().get(this.getBaseUrlInternal() + "opennms/");
        this.getDriver().findElement(By.id((String)"index-contentmiddle"));
    }

    public void adminPage() {
        LOG.debug("navigating to the admin page");
        this.getDriver().get(this.getBaseUrlInternal() + "opennms/admin/index.jsp");
    }

    protected void nodePage() {
        LOG.debug("navigating to the node page");
        this.getDriver().get(this.getBaseUrlInternal() + "opennms/element/nodeList.htm");
    }

    protected void notificationsPage() {
        LOG.debug("navigating to the notifications page");
        this.getDriver().get(this.getBaseUrlInternal() + "opennms/notification/index.jsp");
    }

    protected void outagePage() {
        LOG.debug("navigating to the outage page");
        this.getDriver().get(this.getBaseUrlInternal() + "opennms/outage/index.jsp");
    }

    protected void provisioningPage() {
        LOG.debug("navigating to the provisioning page");
        this.getDriver().get(this.getBaseUrlInternal() + "opennms/admin/index.jsp");
        this.getDriver().findElement(By.linkText((String)"Manage Provisioning Requisitions")).click();
    }

    protected void reportsPage() {
        LOG.debug("navigating to the reports page");
        this.getDriver().get(this.getBaseUrlInternal() + "opennms/report/index.jsp");
    }

    protected void searchPage() {
        LOG.debug("navigating to the search page");
        this.getDriver().get(this.getBaseUrlInternal() + "opennms/element/index.jsp");
    }

    protected void supportPage() {
        LOG.debug("navigating to the support page");
        this.getDriver().get(this.getBaseUrlInternal() + "opennms/support/index.jsp");
    }

    protected void goBack() {
        LOG.warn("hitting the 'back' button");
        this.getDriver().navigate().back();
    }

    public WebElement clickElement(final By by) {
        return this.waitUntil(new Callable<WebElement>(){

            @Override
            public WebElement call() throws Exception {
                WebElement el = AbstractOpenNMSSeleniumHelper.this.getElementImmediately(by);
                el.click();
                return el;
            }
        });
    }

    public WebElement waitForElement(By by) {
        return this.waitForElement(this.wait, by);
    }

    public WebElement waitForElement(WebDriverWait w, final By by) {
        return this.waitUntil(null, w, new Callable<WebElement>(){

            @Override
            public WebElement call() throws Exception {
                WebElement el = AbstractOpenNMSSeleniumHelper.this.getDriver().findElement(by);
                if (el.isDisplayed() && el.isEnabled()) {
                    return el;
                }
                return null;
            }
        });
    }

    public void enterAutocompleteText(final By textInput, final String text) {
        this.waitUntil((Long)100L, null, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                AbstractOpenNMSSeleniumHelper.this.waitForElement(textInput).clear();
                AbstractOpenNMSSeleniumHelper.this.waitForElement(textInput).click();
                AbstractOpenNMSSeleniumHelper.this.waitForElement(textInput).sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"}), Keys.BACK_SPACE});
                AbstractOpenNMSSeleniumHelper.this.waitForValue(textInput, "");
                AbstractOpenNMSSeleniumHelper.this.waitForElement(textInput).sendKeys(new CharSequence[]{text});
                AbstractOpenNMSSeleniumHelper.this.findElementByXpath("//span[text()='" + text + "']").click();
                return true;
            }
        });
    }

    public void clickUntilVaadinPopupAppears(final By by, final String title) {
        this.waitUntil((Long)100L, null, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                WebDriver driver = AbstractOpenNMSSeleniumHelper.this.getDriver();
                WebElement popup = AbstractOpenNMSSeleniumHelper.this.getVaadinPopup(driver, title);
                if (popup == null) {
                    try {
                        LOG.debug("clickUntilVaadinPopupAppears: looking for '{}'", (Object)by);
                        WebElement el = AbstractOpenNMSSeleniumHelper.this.getElementImmediately(by);
                        if (el == null) {
                            LOG.debug("clickUntilVaadinPopupAppears: element not found: {}", (Object)by);
                            AbstractOpenNMSSeleniumHelper.this.sleepQuietly(50);
                            return false;
                        }
                        LOG.debug("clickUntilVaadinPopupAppears: clicking element: {}", (Object)el);
                        el.click();
                        AbstractOpenNMSSeleniumHelper.this.sleepQuietly(50);
                    }
                    catch (Throwable t) {
                        LOG.debug("clickUntilVaadinPopupAppears: exception raised while attempting to click {}", (Object)by, (Object)t);
                        return false;
                    }
                    popup = AbstractOpenNMSSeleniumHelper.this.getVaadinPopup(driver, title);
                    if (popup != null) {
                        return true;
                    }
                } else {
                    if (popup.isDisplayed() && popup.isEnabled()) {
                        return true;
                    }
                    LOG.debug("clickUntilVaadinPopupAppears: popup with title '{}' is gone", (Object)title);
                }
                return false;
            }
        });
        this.waitFor(1L);
    }

    public void clickUntilVaadinPopupDisappears(final By by, final String title) {
        this.waitUntil((Long)100L, null, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                WebDriver driver = AbstractOpenNMSSeleniumHelper.this.getDriver();
                WebElement popup = AbstractOpenNMSSeleniumHelper.this.getVaadinPopup(driver, title);
                if (popup != null) {
                    try {
                        LOG.debug("clickIdUntilVaadinPopupDisappears: looking for '{}'", (Object)by);
                        WebElement el = AbstractOpenNMSSeleniumHelper.this.getElementImmediately(by);
                        if (el == null) {
                            LOG.debug("clickIdUntilVaadinPopupDisappears: element not found: {}", (Object)by);
                            AbstractOpenNMSSeleniumHelper.this.sleepQuietly(50);
                            return false;
                        }
                        LOG.debug("clickIdUntilVaadinPopupDisappears: clicking element: {}", (Object)el);
                        el.click();
                        AbstractOpenNMSSeleniumHelper.this.sleepQuietly(50);
                    }
                    catch (Throwable t) {
                        LOG.debug("clickUntilVaadinPopupDisappears: exception raised while attempting to click {}", (Object)by, (Object)t);
                        return false;
                    }
                    popup = AbstractOpenNMSSeleniumHelper.this.getVaadinPopup(driver, title);
                    if (popup == null) {
                        return true;
                    }
                } else {
                    return true;
                }
                return false;
            }
        });
        this.waitFor(1L);
    }

    protected boolean inVaadin() {
        try {
            WebElement element = this.getElementImmediately(By.className((String)"v-generated-body"));
            if (element != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected void selectVaadinFrame() {
        if (!this.inVaadin()) {
            LOG.debug("Switching to Vaadin frame.");
            this.getDriver().switchTo().frame(this.findElementById("vaadin-content"));
        }
    }

    protected void selectDefaultFrame() {
        LOG.debug("Switching to default frame.");
        this.getDriver().switchTo().defaultContent();
    }

    public WebElement getVaadinPopup(String title) {
        return this.getVaadinPopup(this.getDriver(), title);
    }

    private WebElement getVaadinPopup(WebDriver driver, String title) {
        this.selectVaadinFrame();
        try {
            LOG.debug("Checking for Vaadin popup '{}'", (Object)title);
            By vaadinHeaderXpath = By.xpath((String)("//div[@class='popupContent']//div[contains(text(), '" + title + "') and @class='v-window-header']"));
            WebElement el = this.getElementImmediately(vaadinHeaderXpath);
            LOG.debug("Found Vaadin popup '{}': {}", (Object)title, (Object)el.toString());
            return el;
        }
        catch (Throwable t) {
            LOG.debug("Did not find Vaadin popup '{}'", (Object)title);
            return null;
        }
    }

    public void selectByVisibleText(final String id, final String text) {
        LOG.debug("selectByVisibleText: id={}, text={}", (Object)id, (Object)text);
        this.waitUntil(null, null, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Select select = AbstractOpenNMSSeleniumHelper.this.getSelect(id);
                select.selectByVisibleText(text);
                return true;
            }
        });
    }

    public Select getSelect(final String id) {
        LOG.debug("Getting <div id='{}'><select />", (Object)id);
        WebElement div = this.waitUntil(null, null, new Callable<WebElement>(){

            @Override
            public WebElement call() throws Exception {
                LOG.debug("Searching for id '{}'", (Object)id);
                WebElement el = AbstractOpenNMSSeleniumHelper.this.getElementImmediately(By.id((String)id));
                if (el != null && el.isDisplayed() && el.isEnabled()) {
                    return el;
                }
                return null;
            }
        });
        LOG.debug("Found id: {} -- looking for select element.", (Object)div);
        WebElement element = div.findElement(By.tagName((String)"select"));
        LOG.debug("Found select: {}", (Object)element);
        return new Select(element);
    }

    public WebElement findElementById(String id) {
        LOG.debug("findElementById: id={}", (Object)id);
        return this.getDriver().findElement(By.id((String)id));
    }

    public WebElement findElementByLink(String link) {
        LOG.debug("findElementByLink: link={}", (Object)link);
        return this.getDriver().findElement(By.linkText((String)link));
    }

    public WebElement findElementByName(String name) {
        LOG.debug("findElementByName: name={}", (Object)name);
        return this.getDriver().findElement(By.name((String)name));
    }

    public WebElement findElementByCss(String css) {
        LOG.debug("findElementByCss: selector={}", (Object)css);
        return this.getDriver().findElement(By.cssSelector((String)css));
    }

    public WebElement findElementByXpath(String xpath) {
        LOG.debug("findElementByXpath: selector={}", (Object)xpath);
        return this.getDriver().findElement(By.xpath((String)xpath));
    }

    public int countElementsMatchingCss(String css) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        LOG.debug("countElementsMatchingCss: selector={}", (Object)css);
        Document doc = Jsoup.parse((String)this.getDriver().getPageSource());
        Elements matching = doc.select(css);
        return matching.size();
    }

    public WebElement enterText(By selector, CharSequence ... text) {
        StringBuilder sb = new StringBuilder();
        for (CharSequence seq : text) {
            sb.append(seq);
        }
        String textString = sb.toString();
        LOG.debug("Enter text: '{}' into selector: '{}'", (Object)text, (Object)selector);
        this.scrollToElement(selector);
        WebElement el = this.waitForElement(selector);
        if (el.isDisplayed() && el.isEnabled()) {
            el.click();
        }
        this.sleep(500);
        long end = System.currentTimeMillis() + LOAD_TIMEOUT;
        boolean found = false;
        int count = 0;
        WebDriverWait shortWait = new WebDriverWait(this.getDriver(), Duration.ofSeconds(10L));
        do {
            LOG.debug("enterText({},{}): {}", new Object[]{selector, text, ++count});
            this.waitForElement(selector).clear();
            this.waitForElement(selector).click();
            this.waitForValue(selector, "");
            this.waitForElement(selector).click();
            this.sleep(500);
            this.waitForElement(selector).sendKeys(text);
            this.waitForElement(selector).click();
            this.sleep(500);
            if (text.length == 1 && text[0] != Keys.ENTER) {
                try {
                    String elementText = this.waitForElement(shortWait, selector).getText();
                    String elementValue = this.waitForElement(shortWait, selector).getAttribute("value");
                    found = elementText.contains(textString) || elementValue.contains(textString);
                }
                catch (Exception e) {
                    LOG.warn("Failed when checking for {} to equal '{}'.", new Object[]{selector, textString, e});
                }
                continue;
            }
            LOG.info("Skipped waiting for {} to equal {}", (Object)selector, (Object)textString);
            found = true;
        } while (!found && System.currentTimeMillis() < end);
        return this.getDriver().findElement(selector);
    }

    protected void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new OpenNMSTestException(e);
        }
    }

    public void sleepQuietly(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected void waitForValue(By selector, String expectedValue) {
        LOG.debug("waitForValue({}, \"{}\")", (Object)selector, (Object)expectedValue);
        this.wait.until((Function)((ExpectedCondition)driver -> {
            String value;
            try {
                this.setImplicitWait(200L, TimeUnit.MILLISECONDS);
                value = driver.findElement(selector).getAttribute("value");
            }
            catch (NoSuchElementException nse) {
                LOG.debug("Element not found yet.");
                throw nse;
            }
            catch (StaleElementReferenceException sere) {
                LOG.debug("Element was found but was already stale by the time we queried the attribute. Trying again.");
                value = driver.findElement(selector).getAttribute("value");
            }
            finally {
                this.setImplicitWait();
            }
            LOG.debug("Found element with value: {}", (Object)value);
            return expectedValue.equals(value);
        }));
    }

    protected WebElement scrollToElement(WebElement element) {
        return AbstractOpenNMSSeleniumHelper.scrollToElement(this.getDriver(), element);
    }

    protected static WebElement scrollToElement(WebDriver driver, WebElement element) {
        LOG.debug("scrollToElement: element={}", (Object)element);
        List<Integer> bounds = AbstractOpenNMSSeleniumHelper.getAbsoluteBoundedRectangleOfElement(driver, element);
        int windowHeight = driver.manage().window().getSize().getHeight();
        JavascriptExecutor je = (JavascriptExecutor)driver;
        je.executeScript("window.scrollTo(0, " + (bounds.get(1) - windowHeight / 2) + ");", new Object[0]);
        return element;
    }

    protected WebElement scrollToElement(By by) {
        return this.scrollToElement(by, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebElement scrollToElement(final By by, final boolean waitForElement) {
        LOG.debug("scrollToElement: by={}", (Object)by);
        if (waitForElement) {
            try {
                this.setImplicitWait(200L, TimeUnit.MILLISECONDS);
                WebElement element = (WebElement)this.wait.until((Function)new ExpectedCondition<WebElement>(){

                    public WebElement apply(WebDriver driver) {
                        WebElement el = waitForElement ? AbstractOpenNMSSeleniumHelper.this.waitForElement(by) : driver.findElement(by);
                        return AbstractOpenNMSSeleniumHelper.this.doScroll(driver, el);
                    }
                });
                if (element == null) {
                    throw new OpenNMSTestException("Failed to scroll to element: " + by);
                }
                WebElement webElement = element;
                return webElement;
            }
            finally {
                this.setImplicitWait();
            }
        }
        WebDriver driver = this.getDriver();
        WebElement el = driver.findElement(by);
        return this.doScroll(driver, el);
    }

    private WebElement doScroll(WebDriver driver, WebElement element) {
        try {
            List<Integer> bounds = AbstractOpenNMSSeleniumHelper.getAbsoluteBoundedRectangleOfElement(driver, element);
            Dimension windowSize = driver.manage().window().getSize();
            JavascriptExecutor je = (JavascriptExecutor)driver;
            int x = bounds.get(0) < windowSize.width && bounds.get(0) + bounds.get(2) < windowSize.width ? 0 : bounds.get(0) - windowSize.width / 2;
            int y = bounds.get(1) < windowSize.height && bounds.get(1) + bounds.get(3) < windowSize.height ? 0 : bounds.get(1) - windowSize.height / 2;
            je.executeScript("window.scrollTo(" + x + ", " + y + ");", new Object[0]);
            LOG.debug("doScroll: element={}, x={}, y={}, windowSize={}x{}, bounds={}", new Object[]{element, x, y, windowSize.width, windowSize.height, bounds});
            return element;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void clickElementUntilElementDisappears(final By click, final By disappears) {
        this.waitUntil((Long)100L, null, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                WebElement element;
                try {
                    element = AbstractOpenNMSSeleniumHelper.this.getElementImmediately(disappears);
                    if (element == null) {
                        return true;
                    }
                }
                catch (NoSuchElementException e) {
                    return true;
                }
                catch (Throwable t) {
                    LOG.warn("clickElementUntilItDisappears: disappearing element not gone yet: click={}, disappears={}", new Object[]{click, disappears, t});
                    return false;
                }
                try {
                    element = AbstractOpenNMSSeleniumHelper.this.getElementImmediately(click);
                    if (element != null) {
                        element.click();
                    }
                }
                catch (Throwable t) {
                    LOG.warn("clickElementUntilItDisappears: unable to click clickable: click={}, disappears={}", new Object[]{click, disappears, t});
                }
                return false;
            }
        });
    }

    protected static List<Integer> getAbsoluteBoundedRectangleOfElement(WebDriver driver, WebElement we) {
        JavascriptExecutor je = (JavascriptExecutor)driver;
        ArrayList bounds = (ArrayList)je.executeScript("var rect = arguments[0].getBoundingClientRect();return [ '' + parseInt(rect.left + window.scrollX), '' + parseInt(rect.top + window.scrollY), '' + parseInt(rect.width), '' + parseInt(rect.height) ]", new Object[]{we});
        Assert.assertEquals((String)"bounding box array size returned from Javascript", (long)4L, (long)bounds.size());
        ArrayList<Integer> ret = new ArrayList<Integer>(bounds.size());
        for (String entry : bounds) {
            ret.add(Integer.valueOf(entry));
        }
        LOG.debug("getAbsoluteBoundedRectangleOfElement: element={}, ret={}", (Object)we, ret);
        return ret;
    }

    protected void clickId(String id) throws InterruptedException {
        this.clickId(id, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clickId(String id, boolean refresh) throws InterruptedException {
        LOG.debug("clickId: id={}, refresh={}", (Object)id, (Object)refresh);
        WebElement element = null;
        this.waitUntil(org.openqa.selenium.support.ui.ExpectedConditions.visibilityOfElementLocated((By)By.id((String)id)));
        this.waitUntil(org.openqa.selenium.support.ui.ExpectedConditions.elementToBeClickable((By)By.id((String)id)));
        try {
            this.setImplicitWait(10L, TimeUnit.MILLISECONDS);
            try {
                element = this.findElementById(id);
            }
            catch (Throwable t) {
                LOG.warn("Failed to locate id={}", (Object)id, (Object)t);
            }
            long waitUntil = System.currentTimeMillis() + 60000L;
            while (!(element != null && element.getAttribute("disabled") == null && element.isDisplayed() && element.isEnabled() || System.currentTimeMillis() >= waitUntil)) {
                try {
                    if (refresh) {
                        this.getDriver().navigate().refresh();
                    }
                    this.wait.until((Function)org.openqa.selenium.support.ui.ExpectedConditions.visibilityOfElementLocated((By)By.id((String)id)));
                    this.wait.until((Function)org.openqa.selenium.support.ui.ExpectedConditions.elementToBeClickable((By)By.id((String)id)));
                    element = this.findElementById(id);
                }
                catch (Throwable t) {
                    LOG.warn("Failed to locate id={}", (Object)id, (Object)t);
                }
            }
            this.sleepQuietly(50);
            element.click();
        }
        finally {
            this.setImplicitWait();
        }
    }

    public <T> T waitUntil(Callable<T> callable) {
        return this.waitUntil(null, this.wait, callable);
    }

    public <T> T waitUntil(WebDriverWait w, Callable<T> callable) {
        return this.waitUntil(null, w, callable);
    }

    public <T> T waitUntil(Long implicitWait, WebDriverWait w, final Callable<T> callable) {
        return this.waitUntil(implicitWait, w, new ExpectedCondition<T>(){

            public T apply(WebDriver driver) {
                try {
                    return callable.call();
                }
                catch (Throwable t) {
                    return null;
                }
            }
        });
    }

    public <T> T waitUntil(ExpectedCondition<T> condition) {
        return this.waitUntil(null, this.wait, condition);
    }

    public <T> T waitUntil(WebDriverWait w, ExpectedCondition<T> condition) {
        return this.waitUntil(null, w, condition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T waitUntil(Long implicitWait, WebDriverWait w, ExpectedCondition<T> condition) {
        WebDriverWait wdw = w == null ? this.wait : w;
        try {
            this.setImplicitWait(implicitWait == null ? 50L : implicitWait, TimeUnit.MILLISECONDS);
            Object object = wdw.until(condition);
            return (T)object;
        }
        finally {
            this.setImplicitWait();
        }
    }

    public static Integer doRequest(HttpRequestBase request) throws ClientProtocolException, IOException, InterruptedException {
        return AbstractOpenNMSSeleniumHelper.getRequest(request).getStatus();
    }

    protected static ResponseData getRequest(HttpRequestBase request) throws ClientProtocolException, IOException, InterruptedException {
        final CountDownLatch waitForCompletion = new CountDownLatch(1);
        URI uri = request.getURI();
        HttpHost targetHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()), (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(targetHost, (AuthScheme)basicAuth);
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider((CredentialsProvider)credsProvider);
        context.setAuthCache((AuthCache)authCache);
        CloseableHttpClient client = HttpClients.createDefault();
        ResponseHandler<ResponseData> responseHandler = new ResponseHandler<ResponseData>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ResponseData handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                try {
                    int status = response.getStatusLine().getStatusCode();
                    String responseText = null;
                    if (status >= 200 && status < 300 || status == 400 || status == 404) {
                        ResponseData r;
                        HttpEntity entity = response.getEntity();
                        if (entity != null) {
                            responseText = EntityUtils.toString((HttpEntity)entity);
                            EntityUtils.consume((HttpEntity)entity);
                        }
                        ResponseData responseData = r = new ResponseData(status, responseText);
                        return responseData;
                    }
                    try {
                        throw new ClientProtocolException("Unexpected response status: " + status);
                    }
                    catch (Exception e) {
                        LOG.warn("Unhandled exception", (Throwable)e);
                        ResponseData responseData = new ResponseData(-1, null);
                        return responseData;
                    }
                }
                finally {
                    waitForCompletion.countDown();
                }
            }
        };
        ResponseData result = (ResponseData)client.execute(targetHost, (HttpRequest)request, (ResponseHandler)responseHandler, (HttpContext)context);
        waitForCompletion.await();
        client.close();
        return result;
    }

    public long getNodesInDatabase(String foreignSource) {
        try {
            HttpGet request = new HttpGet(this.getBaseUrlExternal() + "opennms/rest/nodes?foreignSource=" + URLEncoder.encode(foreignSource, "UTF-8"));
            ResponseData rd = AbstractOpenNMSSeleniumHelper.getRequest((HttpRequestBase)request);
            LOG.debug("getNodesInDatabase: response={}", (Object)rd);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            org.w3c.dom.Document document = builder.parse(new InputSource(new StringReader(rd.getResponseText())));
            Element rootElement = document.getDocumentElement();
            return Long.valueOf(rootElement.getAttribute("totalCount"), 10);
        }
        catch (Exception e) {
            throw new OpenNMSTestException(e);
        }
    }

    public boolean requisitionExists(String foreignSource) {
        try {
            String foreignSourceUrlFragment = URLEncoder.encode(foreignSource, "UTF-8");
            Integer status = AbstractOpenNMSSeleniumHelper.doRequest((HttpRequestBase)new HttpGet(this.getBaseUrlExternal() + "opennms/rest/requisitions/" + foreignSourceUrlFragment));
            LOG.debug("requisitionExists: foreignSource={}, status={}", (Object)foreignSource, (Object)status);
            return status == 200;
        }
        catch (IOException | InterruptedException e) {
            LOG.debug("requisitionExists: failed:", (Throwable)e);
            throw new OpenNMSTestException(e);
        }
    }

    public void deleteExistingRequisition(String foreignSource) {
        LOG.debug("deleteExistingRequisition: Deleting Requisition: {}", (Object)foreignSource);
        long waitUntil = System.currentTimeMillis() + 300000L;
        do {
            long nodesInRequisition = -1L;
            long nodesInDatabase = -1L;
            try {
                nodesInRequisition = this.getNodesInRequisition(foreignSource);
                nodesInDatabase = this.getNodesInDatabase(foreignSource);
                LOG.debug("deleteExistingRequisition: nodesInRequisition={}, nodesInDatabase={}", (Object)nodesInRequisition, (Object)nodesInDatabase);
                String foreignSourceUrlFragment = URLEncoder.encode(foreignSource, "UTF-8");
                if (nodesInDatabase > 0L) {
                    this.createRequisition(foreignSource);
                }
                if (this.requisitionExists(foreignSource)) {
                    this.sendDelete("/rest/requisitions/" + foreignSourceUrlFragment);
                    this.sendDelete("/rest/requisitions/deployed/" + foreignSourceUrlFragment);
                    this.sendDelete("/rest/foreignSources/" + foreignSourceUrlFragment);
                    this.sendDelete("/rest/foreignSources/deployed/" + foreignSourceUrlFragment);
                }
                this.sleepQuietly(500);
            }
            catch (Exception e) {
                throw new OpenNMSTestException(e);
            }
            if (System.currentTimeMillis() <= waitUntil) continue;
            throw new OpenNMSTestException("Gave up waiting to delete requisition '" + foreignSource + "'.  This should totally not happen.");
        } while (this.requisitionExists(foreignSource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected WebElement getForeignSourceElement(String requisitionName) {
        LOG.debug("getForeignSourceElement: requisition={}", (Object)requisitionName);
        String selector = "//span[@data-foreignSource='" + requisitionName + "']";
        WebElement foreignSourceElement = null;
        try {
            this.setImplicitWait(2L, TimeUnit.SECONDS);
            foreignSourceElement = this.getDriver().findElement(By.xpath((String)selector));
        }
        catch (NoSuchElementException e) {
            LOG.debug("Could not find: {}", (Object)selector);
            WebElement webElement = null;
            return webElement;
        }
        finally {
            this.setImplicitWait();
        }
        return foreignSourceElement;
    }

    protected void createTestRequisition() {
        this.createRequisition(REQUISITION_NAME);
    }

    protected void createRequisition(String foreignSource) {
        LOG.debug("Creating empty requisition: {}", (Object)foreignSource);
        String emptyRequisition = "<model-import xmlns=\"http://xmlns.opennms.org/xsd/config/model-import\" date-stamp=\"2013-03-29T11:36:55.901-04:00\" foreign-source=\"" + foreignSource + "\" last-import=\"2016-03-29T10:40:23.947-04:00\"></model-import>";
        this.createRequisition(foreignSource, emptyRequisition, 0);
    }

    protected void createRequisition(String foreignSource, String xml, int expectedNodes) {
        LOG.debug("Creating requisition from XML: {}", (Object)foreignSource);
        try {
            String foreignSourceUrlFragment = URLEncoder.encode(foreignSource, "UTF-8");
            this.sendPost("/rest/requisitions", xml);
            this.requisitionWait.until((Function)((Object)new WaitForNodesInRequisition(expectedNodes)));
            HttpPut request = new HttpPut(this.getBaseUrlExternal() + "opennms/rest/requisitions/" + foreignSourceUrlFragment + "/import");
            Integer status = AbstractOpenNMSSeleniumHelper.doRequest((HttpRequestBase)request);
            if (status == null || status < 200 || status >= 400) {
                throw new OpenNMSTestException("Unknown status: " + status);
            }
            this.requisitionWait.until((Function)((Object)new WaitForNodesInDatabase(expectedNodes)));
        }
        catch (Exception e) {
            throw new OpenNMSTestException(e);
        }
    }

    protected void deleteTestRequisition() throws Exception {
        this.deleteExistingRequisition(REQUISITION_NAME);
    }

    protected void createTestForeignSource(String xml) {
        this.createForeignSource(REQUISITION_NAME, xml);
    }

    protected void createForeignSource(final String foreignSource, String xml) {
        LOG.debug("Creating foreign source definition: {}", (Object)foreignSource);
        try {
            this.sendPost("/rest/foreignSources", xml);
            AbstractOpenNMSSeleniumHelper.doRequest((HttpRequestBase)new HttpGet(this.getBaseUrlExternal() + "opennms/rest/foreignSources"));
            this.waitUntil(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return 200 == AbstractOpenNMSSeleniumHelper.doRequest((HttpRequestBase)new HttpGet(AbstractOpenNMSSeleniumHelper.this.getBaseUrlExternal() + "opennms/rest/foreignSources/" + URLEncoder.encode(foreignSource, Charset.defaultCharset().toString())));
                }
            });
        }
        catch (Exception e) {
            throw new OpenNMSTestException(e);
        }
    }

    protected void deleteTestForeignSource() {
        this.deleteExistingForeignSource(REQUISITION_NAME);
    }

    protected void deleteExistingForeignSource(String foreignSource) {
        LOG.debug("Deleting foreign source definition: {}", (Object)foreignSource);
        try {
            String foreignSourceUrlFragment = URLEncoder.encode(foreignSource, "UTF-8");
            this.sendDelete("/rest/foreignSources/" + foreignSourceUrlFragment);
        }
        catch (Exception e) {
            throw new OpenNMSTestException(e);
        }
    }

    protected void deleteTestUser() throws Exception {
        LOG.debug("deleteTestUser()");
        AbstractOpenNMSSeleniumHelper.doRequest((HttpRequestBase)new HttpDelete(this.getBaseUrlExternal() + "opennms/rest/users/SmokeTestUser"));
    }

    protected void deleteTestGroup() throws Exception {
        LOG.debug("deleteTestGroup()");
        AbstractOpenNMSSeleniumHelper.doRequest((HttpRequestBase)new HttpDelete(this.getBaseUrlExternal() + "opennms/rest/groups/SmokeTestGroup"));
    }

    protected long getNodesInRequisition(String foreignSource) {
        try {
            HttpGet request = new HttpGet(this.getBaseUrlExternal() + "opennms/rest/requisitions/" + URLEncoder.encode(foreignSource, "UTF-8"));
            ResponseData rd = AbstractOpenNMSSeleniumHelper.getRequest((HttpRequestBase)request);
            LOG.debug("getNodesInRequisition: response={}", (Object)rd);
            if (rd.getStatus() == 404 || rd.getStatus() == -1 || rd.getResponseText() == null) {
                return 0L;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            org.w3c.dom.Document document = builder.parse(new InputSource(new StringReader(rd.getResponseText())));
            Element rootElement = document.getDocumentElement();
            long count = 0L;
            NodeList children = rootElement.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!"node".equals(child.getNodeName())) continue;
                ++count;
            }
            return count;
        }
        catch (Exception e) {
            throw new OpenNMSTestException(e);
        }
    }

    @Deprecated
    protected long getNodesInRequisition(WebElement element) {
        LOG.debug("getNodesInRequisition: element={}", (Object)element);
        try {
            WebElement match = element.findElement(By.xpath((String)"//span[@data-requisitionedNodes]"));
            String nodes = match.getAttribute("data-requisitionedNodes");
            if (nodes != null) {
                Long nodeCount = Long.valueOf(nodes);
                LOG.debug("{} requisitioned nodes found.", (Object)nodeCount);
                return nodeCount;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        LOG.debug("0 requisitioned nodes found.");
        return 0L;
    }

    @Deprecated
    protected long getNodesInDatabase(WebElement element) {
        LOG.debug("getNodesInDatabase: element={}", (Object)element);
        try {
            WebElement match = element.findElement(By.xpath((String)"//span[@data-databaseNodes]"));
            String nodes = match.getAttribute("data-databaseNodes");
            if (nodes != null) {
                Long nodeCount = Long.valueOf(nodes);
                LOG.debug("{} database nodes found.", (Object)nodeCount);
                return nodeCount;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        LOG.debug("0 database nodes found.");
        return 0L;
    }

    protected void sendPost(String urlFragment, String body) throws ClientProtocolException, IOException, InterruptedException {
        this.sendPost(urlFragment, body, null);
    }

    public void sendPost(String urlFragment, String body, Integer expectedResponse) throws ClientProtocolException, IOException, InterruptedException {
        LOG.debug("sendPost: url={}, expectedResponse={}, body={}", new Object[]{urlFragment, expectedResponse, body});
        HttpPost post = new HttpPost(this.buildUrlExternal(urlFragment));
        post.setEntity((HttpEntity)new StringEntity(body, ContentType.APPLICATION_XML));
        Integer response = AbstractOpenNMSSeleniumHelper.doRequest((HttpRequestBase)post);
        if (expectedResponse == null) {
            if (response == null || response != 303 && response != 200 && response != 201 && response != 202) {
                throw new RuntimeException("Bad response code! (" + response + "; expected 200, 201, 202, or 303)");
            }
        } else if (!expectedResponse.equals(response)) {
            throw new RuntimeException("Bad response code! (" + response + "; expected " + expectedResponse + ")");
        }
    }

    protected void sendPut(String urlFragment, String body) throws ClientProtocolException, IOException, InterruptedException {
        this.sendPut(urlFragment, body, null);
    }

    protected void sendPut(String urlFragment, String body, Integer expectedResponse) throws ClientProtocolException, IOException, InterruptedException {
        LOG.debug("sendPut: url={}, expectedResponse={}, body={}", new Object[]{urlFragment, expectedResponse, body});
        HttpPut put = new HttpPut(this.buildUrlExternal(urlFragment));
        put.setEntity((HttpEntity)new StringEntity(body, ContentType.APPLICATION_FORM_URLENCODED));
        Integer response = AbstractOpenNMSSeleniumHelper.doRequest((HttpRequestBase)put);
        if (expectedResponse == null) {
            if (response == null || response != 303 && response != 200 && response != 201 && response != 202) {
                throw new RuntimeException("Bad response code! (" + response + "; expected 200, 201, 202, or 303)");
            }
        } else if (!expectedResponse.equals(response)) {
            throw new RuntimeException("Bad response code! (" + response + "; expected " + expectedResponse + ")");
        }
    }

    protected void sendDelete(String urlFragment) throws ClientProtocolException, IOException, InterruptedException {
        this.sendDelete(urlFragment, null);
    }

    protected void sendDelete(String urlFragment, Integer expectedResponse) throws ClientProtocolException, IOException, InterruptedException {
        LOG.debug("sendDelete: url={}, expectedResponse={}", (Object)urlFragment, (Object)expectedResponse);
        HttpDelete del = new HttpDelete(this.getBaseUrlExternal() + "opennms" + (String)(urlFragment.startsWith("/") ? urlFragment : "/" + urlFragment));
        Integer response = AbstractOpenNMSSeleniumHelper.doRequest((HttpRequestBase)del);
        if (expectedResponse == null) {
            if (response == null || response != 303 && response != 200 && response != 202 && response != 204) {
                throw new RuntimeException("Bad response code! (" + response + "; expected 200, 202, 204, or 303)");
            }
        } else if (!expectedResponse.equals(response)) {
            throw new RuntimeException("Bad response code! (" + response + "; expected " + expectedResponse + ")");
        }
    }

    protected String buildUrlInternal(String urlFragment) {
        return this.getBaseUrlInternal() + "opennms" + (String)(urlFragment.startsWith("/") ? urlFragment : "/" + urlFragment);
    }

    protected String buildUrlExternal(String urlFragment) {
        return this.getBaseUrlExternal() + "opennms" + (String)(urlFragment.startsWith("/") ? urlFragment : "/" + urlFragment);
    }

    public File getDownloadsFolder() {
        return DOWNLOADS_FOLDER;
    }

    public void cleanDownloadsFolder() {
        try {
            FileUtils.cleanDirectory((File)DOWNLOADS_FOLDER);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final class WaitForNodesInRequisition
    implements ExpectedCondition<Boolean> {
        private final String m_foreignSource;
        private final int m_numberToMatch;

        public WaitForNodesInRequisition(String foreignSource, int numberOfNodes) {
            this.m_foreignSource = foreignSource;
            this.m_numberToMatch = numberOfNodes;
            LOG.debug("WaitForNodesInRequisition: foreignSource={}, expectedNodes={}", (Object)foreignSource, (Object)numberOfNodes);
        }

        public WaitForNodesInRequisition(int numberOfNodes) {
            this.m_foreignSource = AbstractOpenNMSSeleniumHelper.REQUISITION_NAME;
            this.m_numberToMatch = numberOfNodes;
            LOG.debug("WaitForNodesInRequisition: foreignSource={}, expectedNodes={}", (Object)this.m_foreignSource, (Object)numberOfNodes);
        }

        public Boolean apply(WebDriver input) {
            try {
                long nodes = AbstractOpenNMSSeleniumHelper.this.getNodesInRequisition(this.m_foreignSource);
                LOG.debug("WaitForNodesInRequisition: foreignSource={}, count={}", (Object)this.m_foreignSource, (Object)nodes);
                if (nodes == (long)this.m_numberToMatch) {
                    return true;
                }
            }
            catch (Exception e) {
                LOG.warn("WaitForNodesInRequisition: foreignSource={}, expectedNodes={}: Failed to get nodes in requisition.", new Object[]{this.m_foreignSource, this.m_numberToMatch, e});
            }
            return null;
        }
    }

    protected final class WaitForNodesInDatabase
    implements ExpectedCondition<Boolean> {
        private final String m_foreignSource;
        private final int m_numberToMatch;

        public WaitForNodesInDatabase(int numberOfNodes) {
            this(AbstractOpenNMSSeleniumHelper.REQUISITION_NAME, numberOfNodes);
        }

        public WaitForNodesInDatabase(String foreignSource, int numberOfNodes) {
            this.m_foreignSource = foreignSource;
            this.m_numberToMatch = numberOfNodes;
            LOG.debug("WaitForNodesInDatabase: foreignSource={}, expectedNodes={}", (Object)foreignSource, (Object)numberOfNodes);
        }

        public Boolean apply(WebDriver input) {
            try {
                long nodes = AbstractOpenNMSSeleniumHelper.this.getNodesInDatabase(this.m_foreignSource);
                LOG.debug("WaitForNodesInDatabase: foreignSource={}, count={}", (Object)this.m_foreignSource, (Object)nodes);
                if (nodes == (long)this.m_numberToMatch) {
                    return true;
                }
            }
            catch (Exception e) {
                LOG.warn("WaitForNodesInDatabase: foreignSource={}, count={}: Failed while attempting to validate.", new Object[]{this.m_foreignSource, this.m_numberToMatch, e});
            }
            return null;
        }
    }
}

