/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.utils;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.InternetProtocol;
import com.github.dockerjava.api.model.Ports;
import com.google.common.io.CharStreams;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;

public class TestContainerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TestContainerUtils.class);
    public static final int OPENSHIFT_CONTAINER_UID_RANGE_MIN = 1000600000;
    public static final int OPENSHIFT_CONTAINER_UID_RANGE_MAX = 1000700000;
    public static final int OPENSHIFT_CONTAINER_GID = 0;
    private static final int NUM_CPUS_PER_CONTAINER = 2;

    public static void setGlobalMemAndCpuLimits(CreateContainerCmd cmd) {
        HostConfig hostConfig = cmd.getHostConfig();
        if (hostConfig == null) {
            hostConfig = new HostConfig();
        }
        hostConfig.withMemory(Long.valueOf(0x100000000L));
        hostConfig.withCpuPeriod(Long.valueOf(TimeUnit.MILLISECONDS.toMicros(100L)));
        hostConfig.withCpuQuota(Long.valueOf(hostConfig.getCpuPeriod() * 2L));
    }

    public static String getFileFromContainerAsString(Container container, Path pathInContainer) {
        return (String)container.copyFileFromContainer(pathInContainer.toString(), is -> CharStreams.toString((Readable)new InputStreamReader((InputStream)is, StandardCharsets.UTF_8)));
    }

    public static String getInternalIpAddress(Container container) {
        return ((ContainerNetwork)container.getContainerInfo().getNetworkSettings().getNetworks().entrySet().iterator().next().getValue()).getIpAddress();
    }

    public static void restartContainer(Container container) {
        DockerClient docker = container.getDockerClient();
        String id = container.getContainerId();
        try {
            LOG.info("Restarting container: {} -> {}", (Object)container.getDockerImageName(), (Object)id);
            docker.restartContainerCmd(container.getContainerId()).exec();
            LOG.info("Container restarted: {} -> {}", (Object)container.getDockerImageName(), (Object)id);
        }
        catch (DockerException e) {
            LOG.warn("Unexpected exception while restarting container {}", (Object)id, (Object)e);
        }
    }

    public static void exposePortsAsUdp(CreateContainerCmd cmd, int ... ports) {
        ArrayList<ExposedPort> exposedPorts = new ArrayList<ExposedPort>();
        for (ExposedPort p : cmd.getExposedPorts()) {
            exposedPorts.add(p);
        }
        for (int port : ports) {
            exposedPorts.add(ExposedPort.udp((int)port));
        }
        cmd.withExposedPorts(exposedPorts);
        Ports ports2 = cmd.getHostConfig().getPortBindings();
        for (int port : ports) {
            ports2.bind(ExposedPort.udp((int)port), Ports.Binding.empty());
        }
        cmd.getHostConfig().withPortBindings(ports2);
    }

    public static int getMappedUdpPort(Container container, int port) {
        ExposedPort searchForPort = new ExposedPort(port, InternetProtocol.UDP);
        Ports.Binding[] bindings = (Ports.Binding[])container.getContainerInfo().getNetworkSettings().getPorts().getBindings().get(searchForPort);
        if (bindings == null || bindings.length == 0) {
            throw new RuntimeException("No exposed port bindings found for " + searchForPort);
        }
        return Integer.parseInt(bindings[0].getHostPortSpec());
    }
}

