/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.telemetry;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.opennms.smoketest.telemetry.Packet;

public interface Payload {
    @NotNull
    public byte[] load() throws IOException;

    public static Payload resource(String filename) {
        Objects.requireNonNull(filename);
        return () -> {
            try (InputStream is = Packet.class.getResourceAsStream(filename);){
                byte[] byArray = ByteStreams.toByteArray((InputStream)is);
                return byArray;
            }
        };
    }

    public static Payload direct(byte ... payload) {
        Objects.requireNonNull(payload);
        return () -> payload;
    }
}

