/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.containers;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.awaitility.Awaitility;
import org.hamcrest.CoreMatchers;
import org.opennms.smoketest.containers.KarafContainer;
import org.opennms.smoketest.stacks.IpcStrategy;
import org.opennms.smoketest.stacks.JsonStoreStrategy;
import org.opennms.smoketest.stacks.SentinelProfile;
import org.opennms.smoketest.stacks.StackModel;
import org.opennms.smoketest.stacks.TimeSeriesStrategy;
import org.opennms.smoketest.utils.DevDebugUtils;
import org.opennms.smoketest.utils.OverlayUtils;
import org.opennms.smoketest.utils.RestHealthClient;
import org.opennms.smoketest.utils.SshClient;
import org.opennms.smoketest.utils.TargetRoot;
import org.opennms.smoketest.utils.TestContainerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.CassandraContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.SelinuxContext;
import org.testcontainers.containers.wait.strategy.AbstractWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.lifecycle.TestDescription;
import org.testcontainers.lifecycle.TestLifecycleAware;
import org.testcontainers.utility.MountableFile;

public class SentinelContainer
extends GenericContainer<SentinelContainer>
implements KarafContainer<SentinelContainer>,
TestLifecycleAware {
    private static final Logger LOG = LoggerFactory.getLogger(SentinelContainer.class);
    private static final int SENTINEL_DEBUG_PORT = 5005;
    private static final int SENTINEL_SSH_PORT = 8301;
    private static final int SENTINEL_JETTY_PORT = 8181;
    static final String IMAGE = "opennms/sentinel";
    static final String ALIAS = "sentinel";
    private final StackModel model;
    private final SentinelProfile profile;
    private final Path overlay;

    public SentinelContainer(StackModel model, SentinelProfile profile) {
        super(IMAGE);
        this.model = Objects.requireNonNull(model);
        this.profile = Objects.requireNonNull(profile);
        this.overlay = this.writeOverlay();
        ((SentinelContainer)((SentinelContainer)((SentinelContainer)((SentinelContainer)((SentinelContainer)((SentinelContainer)((SentinelContainer)((SentinelContainer)((SentinelContainer)((SentinelContainer)((SentinelContainer)((SentinelContainer)((SentinelContainer)((SentinelContainer)((SentinelContainer)((SentinelContainer)((SentinelContainer)((SentinelContainer)((SentinelContainer)((SentinelContainer)((SentinelContainer)((SentinelContainer)this.withExposedPorts(new Integer[]{5005, 8301, 8181})).withEnv("SENTINEL_LOCATION", "Sentinel")).withEnv("SENTINEL_ID", profile.getId())).withEnv("POSTGRES_HOST", "db")).withEnv("POSTGRES_PORT", Integer.toString(PostgreSQLContainer.POSTGRESQL_PORT))).withEnv("POSTGRES_USER", "test")).withEnv("POSTGRES_PASSWORD", "test")).withEnv("OPENNMS_DBNAME", "opennms")).withEnv("OPENNMS_DBUSER", "opennms")).withEnv("OPENNMS_DBPASS", "opennms")).withEnv("OPENNMS_BROKER_URL", "failover:tcp://opennms:61616")).withEnv("OPENNMS_HTTP_USER", "admin")).withEnv("OPENNMS_HTTP_PASS", "admin")).withEnv("OPENNMS_BROKER_USER", "admin")).withEnv("OPENNMS_BROKER_PASS", "admin")).withEnv("JACOCO_AGENT_ENABLED", "1")).withEnv("JAVA_OPTS", "-Xms1g -Xmx1g -Djava.security.egd=file:/dev/./urandom -Dorg.opennms.rrd.storeByForeignSource=true")).withNetwork(Network.SHARED)).withNetworkAliases(new String[]{ALIAS})).withCommand("-f")).waitingFor((WaitStrategy)new WaitForSentinel(this))).withCreateContainerCmdModifier(TestContainerUtils::setGlobalMemAndCpuLimits)).addFileSystemBind(this.overlay.toString(), "/opt/sentinel-overlay", BindMode.READ_ONLY, SelinuxContext.SINGLE);
        if (profile.isJvmDebuggingEnabled()) {
            this.withEnv("KARAF_DEBUG", "true");
            this.withEnv("JAVA_DEBUG_PORT", "*:5005");
        }
        DevDebugUtils.setupMavenRepoBind(this, "/opt/sentinel/.m2");
    }

    private Path writeOverlay() {
        try {
            Path home = Files.createTempDirectory(ALIAS, new FileAttribute[0]).toAbsolutePath();
            this.writeOverlay(home);
            return home;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeOverlay(Path home) throws IOException {
        OverlayUtils.setOverlayPermissions(home);
        OverlayUtils.copyFiles(this.profile.getFiles(), home);
        Path etc = home.resolve("etc");
        Files.createDirectories(etc, new FileAttribute[0]);
        Path opennmsSourceEtcDirectory = new TargetRoot(this.getClass()).getPath("system-test-resources", "etc");
        FileUtils.copyDirectory((File)opennmsSourceEtcDirectory.resolve("telemetryd-adapters").toFile(), (File)etc.resolve("telemetryd-adapters").toFile());
        FileUtils.copyDirectory((File)opennmsSourceEtcDirectory.resolve("resource-types.d").toFile(), (File)etc.resolve("resource-types.d").toFile());
        FileUtils.copyDirectory((File)opennmsSourceEtcDirectory.resolve("datacollection").toFile(), (File)etc.resolve("datacollection").toFile());
        FileUtils.copyFile((File)opennmsSourceEtcDirectory.resolve("datacollection-config.xml").toFile(), (File)etc.resolve("datacollection-config.xml").toFile());
        FileUtils.copyDirectory((File)new File(MountableFile.forClasspathResource((String)"sentinel-overlay").getFilesystemPath()), (File)home.toFile());
        Properties sysProps = this.getSystemProperties();
        File propsFile = etc.resolve("custom.system.properties").toFile();
        try (FileOutputStream fos = new FileOutputStream(propsFile);){
            sysProps.store(fos, "Generated");
        }
        Path bootD = etc.resolve("featuresBoot.d");
        Files.createDirectories(bootD, new FileAttribute[0]);
        OverlayUtils.writeFeaturesBoot(bootD.resolve("stest.boot"), this.getFeaturesOnBoot());
        OverlayUtils.writeProps(etc.resolve("org.opennms.core.ipc.sink.kafka.consumer.cfg"), (Map<String, String>)ImmutableMap.builder().put((Object)"bootstrap.servers", (Object)"kafka:9092").put((Object)"acks", (Object)"1").put((Object)"compression.type", (Object)this.model.getKafkaCompressionStrategy().getCodec()).build());
        OverlayUtils.writeProps(etc.resolve("org.opennms.core.ipc.sink.kafka.cfg"), (Map<String, String>)ImmutableMap.builder().put((Object)"bootstrap.servers", (Object)"kafka:9092").put((Object)"acks", (Object)"1").put((Object)"compression.type", (Object)this.model.getKafkaCompressionStrategy().getCodec()).build());
        OverlayUtils.writeProps(etc.resolve("org.opennms.features.flows.persistence.elastic.cfg"), (Map<String, String>)ImmutableMap.builder().put((Object)"elasticUrl", (Object)"http://elastic:9200").build());
        if (TimeSeriesStrategy.NEWTS.equals((Object)this.model.getTimeSeriesStrategy())) {
            OverlayUtils.writeProps(etc.resolve("org.opennms.newts.config.cfg"), (Map<String, String>)ImmutableMap.builder().put((Object)"hostname", (Object)"cassandra").put((Object)"port", (Object)Integer.toString(CassandraContainer.CQL_PORT)).build());
        }
    }

    public List<String> getFeaturesOnBoot() {
        ArrayList<String> featuresOnBoot = new ArrayList<String>();
        featuresOnBoot.add("sentinel-persistence");
        featuresOnBoot.add("sentinel-core");
        featuresOnBoot.add("opennms-health-rest-service");
        if (IpcStrategy.KAFKA.equals((Object)this.model.getIpcStrategy())) {
            featuresOnBoot.add("sentinel-kafka");
        } else if (IpcStrategy.JMS.equals((Object)this.model.getIpcStrategy())) {
            featuresOnBoot.add("sentinel-jms");
        }
        if (TimeSeriesStrategy.NEWTS.equals((Object)this.model.getTimeSeriesStrategy())) {
            featuresOnBoot.add("sentinel-newts");
        }
        if (this.model.isTelemetryProcessingEnabled()) {
            featuresOnBoot.add("sentinel-flows");
            featuresOnBoot.add("sentinel-telemetry-bmp");
            featuresOnBoot.add("sentinel-telemetry-graphite");
            featuresOnBoot.add("sentinel-telemetry-jti");
            featuresOnBoot.add("sentinel-telemetry-nxos");
        }
        switch (this.model.getBlobStoreStrategy()) {
            case NOOP: {
                featuresOnBoot.add("sentinel-blobstore-noop");
                break;
            }
            case NEWTS_CASSANDRA: {
                featuresOnBoot.add("sentinel-blobstore-cassandra");
            }
        }
        if (this.model.getJsonStoreStrategy() == null || this.model.getJsonStoreStrategy() == JsonStoreStrategy.POSTGRES) {
            featuresOnBoot.add("sentinel-jsonstore-postgres");
        }
        if (this.model.isJaegerEnabled()) {
            featuresOnBoot.add("opennms-core-tracing-jaeger");
        }
        return featuresOnBoot;
    }

    public Properties getSystemProperties() {
        Properties props = new Properties();
        if (this.model.isJaegerEnabled()) {
            props.put("JAEGER_ENDPOINT", "http://jaeger:14268/api/traces");
        }
        return props;
    }

    @Override
    public InetSocketAddress getSshAddress() {
        return new InetSocketAddress(this.getContainerIpAddress(), (int)this.getMappedPort(8301));
    }

    @Override
    public SshClient ssh() {
        return new SshClient(this.getSshAddress(), "admin", "admin");
    }

    @Override
    public Path getKarafHomeDirectory() {
        return Path.of("/opt/sentinel", new String[0]);
    }

    public URL getWebUrl() {
        try {
            return new URL(String.format("http://%s:%d/", this.getContainerIpAddress(), this.getMappedPort(8181)));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public int getWebPort() {
        return 8181;
    }

    public void afterTest(TestDescription description, Optional<Throwable> throwable) {
        this.retainLogsfNeeded(description.getFilesystemFriendlyName(), !throwable.isPresent());
    }

    private void retainLogsfNeeded(String prefix, boolean succeeded) {
        Path targetLogFolder = Paths.get("target", "logs", prefix, ALIAS);
        DevDebugUtils.clearLogs(targetLogFolder);
        AtomicReference threadDump = new AtomicReference();
        Awaitility.await((String)"calling gatherThreadDump").atMost(Duration.ofSeconds(120L)).untilAsserted(() -> threadDump.set(DevDebugUtils.gatherThreadDump(this, targetLogFolder, null)));
        LOG.info("Gathering logs...");
        List<String> logFiles = Arrays.asList("karaf.log");
        DevDebugUtils.copyLogs(this, targetLogFolder, Paths.get("/opt", ALIAS, "data", "log"), logFiles);
        LOG.info("Log directory: {}", (Object)targetLogFolder.toUri());
        LOG.info("Console log: {}", (Object)targetLogFolder.resolve("container_stdout_stderr").toUri());
        if (threadDump.get() != null) {
            LOG.info("Thread dump: {}", (Object)((Path)threadDump.get()).toUri());
        }
    }

    private static class WaitForSentinel
    extends AbstractWaitStrategy {
        private final SentinelContainer container;

        public WaitForSentinel(SentinelContainer container) {
            this.container = Objects.requireNonNull(container);
        }

        protected void waitUntilReady() {
            LOG.info("Waiting for Sentinel health check...");
            RestHealthClient client = new RestHealthClient(this.container.getWebUrl(), Optional.of(SentinelContainer.ALIAS));
            Awaitility.await((String)"waiting for good health check probe").atMost(5L, TimeUnit.MINUTES).pollInterval(10L, TimeUnit.SECONDS).failFast("container is no longer running", () -> !this.container.isRunning()).ignoreExceptionsMatching(e -> e.getCause() != null && e.getCause() instanceof SocketException).until(client::getProbeHealthResponse, CoreMatchers.containsString((String)client.getProbeSuccessMessage()));
            LOG.info("Health check passed.");
            this.container.assertNoKarafDestroy(Paths.get("/opt", SentinelContainer.ALIAS, "data", "log", "karaf.log"));
        }
    }
}

