/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.utils;

import com.google.common.collect.Iterables;
import java.util.concurrent.Callable;
import org.opennms.core.criteria.Criteria;
import org.opennms.netmgt.dao.api.OnmsDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaoUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DaoUtils.class);

    public static Callable<Integer> countMatchingCallable(OnmsDao<?, ?> dao, Criteria criteria) {
        return () -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Counting records matching {} on {}. DAO currently has {} total records.", new Object[]{criteria, dao, dao.countAll()});
            }
            Integer count = dao.countMatching(criteria);
            LOG.info("Count: {}", (Object)count);
            return count;
        };
    }

    public static <T> Callable<T> findMatchingCallable(OnmsDao<?, ?> dao, Criteria criteria) {
        return () -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Finding object matching {} on {}. DAO currently has {} total records.", new Object[]{criteria, dao, dao.countAll()});
            }
            Object entity = Iterables.getFirst((Iterable)dao.findMatching(criteria), null);
            LOG.debug("Found: {}", entity);
            return entity;
        };
    }
}

