/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.api;

import java.beans.PropertyEditorSupport;
import java.util.Date;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class ISO8601DateEditor
extends PropertyEditorSupport {
    private static final DateTimeFormatter m_formatter = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);

    @Override
    public String getAsText() {
        return m_formatter.print(((Date)super.getValue()).getTime());
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        super.setValue(ISO8601DateEditor.stringToDate(text));
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    public static Date stringToDate(String text) throws IllegalArgumentException, UnsupportedOperationException {
        if (text == null || "null".equals(text)) {
            return null;
        }
        try {
            return new Date(Long.parseLong(text, 10));
        }
        catch (NumberFormatException nfe) {
            RuntimeException cause = nfe;
            try {
                return m_formatter.parseDateTime(text).toDate();
            }
            catch (IllegalArgumentException | UnsupportedOperationException e) {
                cause = e;
                throw new IllegalArgumentException("Unable to parse value '" + text + "' as a date.", cause);
            }
        }
    }
}

