/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.category;

import java.io.IOException;
import java.text.DecimalFormat;
import org.opennms.web.category.Category;

public class CategoryUtil {
    public static final DecimalFormat valueFormat = new DecimalFormat("0.000");

    private CategoryUtil() {
    }

    public static String formatValue(double value) {
        return valueFormat.format(value);
    }

    public static String getCategoryClass(Category category) throws IOException {
        if (category == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return CategoryUtil.getCategoryClass(category.getNormalThreshold(), category.getWarningThreshold(), category.getValue());
    }

    public static String getCategoryClass(Category category, double value) throws IOException {
        if (category == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return CategoryUtil.getCategoryClass(category.getNormalThreshold(), category.getWarningThreshold(), value);
    }

    public static String getCategoryClass(double normal, double warning, double value) {
        String m_crit;
        String m_good = "Normal";
        String m_warn = "Warning";
        String _class = m_crit = "Critical";
        if (value >= normal) {
            _class = m_good;
        } else if (value >= warning) {
            _class = m_warn;
        }
        return _class;
    }
}

