/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.resource.Vault;
import org.opennms.web.api.Util;

public class AddStrictTransportSecurityHeaderFilter
implements Filter {
    private String maxAge;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.maxAge = filterConfig.getInitParameter("maxAge");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        boolean httpsEnabledByJetty;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String urlBase = Util.calculateUrlBase(httpServletRequest);
        boolean bl = httpsEnabledByJetty = Vault.getProperty((String)"org.opennms.netmgt.jetty.https-port") != null;
        if (urlBase.startsWith("https://") && httpsEnabledByJetty) {
            httpServletResponse.setHeader("Strict-Transport-Security", "max-age=" + this.maxAge + "; includeSubDomains");
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

