/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.category;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import org.opennms.netmgt.config.ViewsDisplayFactory;
import org.opennms.netmgt.config.viewsdisplay.Section;
import org.opennms.netmgt.config.viewsdisplay.View;
import org.opennms.web.category.Category;
import org.opennms.web.category.CategoryModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryList {
    private static final Logger LOG = LoggerFactory.getLogger(CategoryList.class);
    protected final CategoryModel m_model;
    protected final List<Section> m_sections;
    protected final int m_disconnectTimeout;

    public CategoryList() throws ServletException {
        try {
            this.m_model = CategoryModel.getInstance();
        }
        catch (Throwable e) {
            LOG.error("failed to instantiate the category model: {}", (Object)e, (Object)e);
            throw new ServletException("failed to instantiate the category model: " + e, e);
        }
        List sections = Collections.emptyList();
        int disconnectTimeout = 130000;
        try {
            ViewsDisplayFactory.init();
            ViewsDisplayFactory viewsDisplayFactory = ViewsDisplayFactory.getInstance();
            View view = viewsDisplayFactory.getDefaultView();
            if (view != null) {
                sections = view.getSections();
                disconnectTimeout = viewsDisplayFactory.getDisconnectTimeout();
                LOG.debug("found display rules from viewsdisplay.xml");
            } else {
                LOG.debug("did not find display rules from viewsdisplay.xml");
            }
        }
        catch (Throwable e) {
            LOG.error("Couldn't open viewsdisplay factory on categories box: {}", (Object)e, (Object)e);
        }
        this.m_sections = sections;
        this.m_disconnectTimeout = disconnectTimeout;
    }

    private List<Section> getSections(Map<String, Category> categoryMap) throws IOException {
        if (this.m_sections != null) {
            return this.m_sections;
        }
        ArrayList<Section> sectionList = null;
        Section section = new Section();
        section.setSectionName("Category");
        TreeMap<String, Category> orderedMap = new TreeMap<String, Category>(categoryMap);
        for (Map.Entry<String, Category> entry : orderedMap.entrySet()) {
            Category category = entry.getValue();
            section.addCategory(category.getName());
        }
        sectionList = new ArrayList<Section>();
        sectionList.add(section);
        return sectionList;
    }

    public Map<String, List<Category>> getCategoryData() throws IOException {
        Map<String, Category> categoryMap = this.m_model.getCategoryMap();
        List<Section> sectionList = this.getSections(categoryMap);
        LinkedHashMap categoryData = new LinkedHashMap();
        for (Section section : sectionList) {
            LinkedList<Category> categories = new LinkedList<Category>();
            for (String categoryName : section.getCategories()) {
                Category category = categoryMap.get(categoryName);
                if (category == null) {
                    categories.add(new Category(categoryName));
                    continue;
                }
                categories.add(category);
            }
            categoryData.put(section.getSectionName(), categories);
        }
        return Collections.unmodifiableMap(categoryData);
    }

    public static long getEarliestUpdate(Map<String, List<Category>> categoryData) {
        long earliestUpdate = 0L;
        for (Map.Entry<String, List<Category>> entry : categoryData.entrySet()) {
            List<Category> categories = entry.getValue();
            for (Category category : categories) {
                if (category.getLastUpdated() == null) {
                    return -1L;
                }
                if (earliestUpdate != 0L && earliestUpdate <= category.getLastUpdated().getTime()) continue;
                earliestUpdate = category.getLastUpdated().getTime();
            }
        }
        return earliestUpdate;
    }

    public boolean isDisconnected() throws IOException {
        return this.isDisconnected(CategoryList.getEarliestUpdate(this.getCategoryData()));
    }

    public boolean isDisconnected(long earliestUpdate) {
        return earliestUpdate < 1L || earliestUpdate + (long)this.m_disconnectTimeout < System.currentTimeMillis();
    }
}

