/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.charts;

import java.awt.Color;
import java.awt.Paint;
import org.opennms.web.charts.CustomSeriesColors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeveritySeriesColors
implements CustomSeriesColors {
    private static final Logger LOG = LoggerFactory.getLogger(SeveritySeriesColors.class);

    @Override
    public Paint getPaint(Comparable<?> cat) {
        int sev = 0;
        String severity = cat.toString();
        Color converted = Color.BLACK;
        try {
            sev = Integer.parseInt(severity);
        }
        catch (NumberFormatException e) {
            LOG.warn("Problem converting severity: {} to an int value.", (Object)severity);
        }
        switch (sev) {
            case 0: {
                break;
            }
            case 1: {
                converted = Color.GRAY;
                break;
            }
            case 2: {
                converted = Color.WHITE;
                break;
            }
            case 3: {
                converted = Color.GREEN;
                break;
            }
            case 4: {
                converted = Color.CYAN;
                break;
            }
            case 5: {
                converted = Color.YELLOW;
                break;
            }
            case 6: {
                converted = Color.ORANGE;
                break;
            }
            case 7: {
                converted = Color.RED;
            }
        }
        return converted;
    }
}

