/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.dao.support;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opennms.netmgt.config.CategoryFactory;
import org.opennms.netmgt.config.categories.Category;
import org.opennms.netmgt.config.categories.CategoryGroup;
import org.opennms.netmgt.config.categories.Catinfo;
import org.opennms.web.svclayer.dao.CategoryConfigDao;
import org.springframework.dao.DataRetrievalFailureException;

public class DefaultCategoryConfigDao
implements CategoryConfigDao {
    public DefaultCategoryConfigDao() {
        try {
            CategoryFactory.init();
        }
        catch (FileNotFoundException e) {
            throw new DataRetrievalFailureException("Unable to locate categories file", (Throwable)e);
        }
        catch (IOException e) {
            throw new DataRetrievalFailureException("Error load categories file", (Throwable)e);
        }
    }

    @Override
    public Category getCategoryByLabel(String label) {
        return CategoryFactory.getInstance().getCategory(label);
    }

    @Override
    public Collection<Category> findAll() {
        ArrayList<Category> catList = new ArrayList<Category>();
        Catinfo catInfo = CategoryFactory.getInstance().getConfig();
        List catGroupList = catInfo.getCategoryGroups();
        if (catGroupList != null) {
            for (CategoryGroup cg : catGroupList) {
                catList.addAll(cg.getCategories());
            }
        }
        return catList;
    }
}

