/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import org.opennms.core.utils.SocketUtils;
import org.opennms.core.utils.SocketWrapper;

public class SslSocketWrapper
implements SocketWrapper {
    private final String[] m_cipherSuites;
    private final String m_protocol;

    public SslSocketWrapper() {
        this(null, null);
    }

    public SslSocketWrapper(String[] cipherSuites) {
        this(null, cipherSuites);
    }

    public SslSocketWrapper(String protocol, String[] cipherSuites) {
        this.m_protocol = protocol == null ? "SSL" : protocol;
        this.m_cipherSuites = cipherSuites == null ? null : Arrays.copyOf(cipherSuites, cipherSuites.length);
    }

    @Override
    public Socket wrapSocket(Socket socket) throws IOException {
        return SocketUtils.wrapSocketInSslContext(socket, this.m_protocol, this.m_cipherSuites);
    }
}

