/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils.jexl;

import org.apache.commons.jexl2.JexlInfo;
import org.apache.commons.jexl2.introspection.JexlMethod;
import org.apache.commons.jexl2.introspection.JexlPropertyGet;
import org.apache.commons.jexl2.introspection.JexlPropertySet;
import org.apache.commons.jexl2.introspection.UberspectImpl;
import org.apache.commons.logging.Log;
import org.opennms.core.utils.jexl.OnmsJexlSandbox;

public class OnmsJexlUberspect
extends UberspectImpl {
    protected final OnmsJexlSandbox sandbox;

    public OnmsJexlUberspect(Log runtimeLogger, OnmsJexlSandbox theSandbox) {
        super(runtimeLogger);
        if (theSandbox == null) {
            throw new NullPointerException("sandbox can not be null");
        }
        this.sandbox = theSandbox;
    }

    public void setLoader(ClassLoader cloader) {
        this.base().setLoader(cloader);
    }

    public JexlMethod getConstructorMethod(Object ctorHandle, Object[] args, JexlInfo info) {
        String className;
        if (ctorHandle instanceof Class) {
            Class clazz = (Class)ctorHandle;
            className = clazz.getName();
        } else {
            if (ctorHandle == null) {
                return null;
            }
            className = ctorHandle.toString();
        }
        return this.sandbox.execute(className, "") != null ? super.getConstructorMethod((Object)className, args, info) : null;
    }

    public JexlMethod getMethod(Object obj, String method, Object[] args, JexlInfo info) {
        if (obj != null && method != null) {
            String className;
            if (obj instanceof Class) {
                Class clazz = (Class)obj;
                className = clazz.getName();
            } else {
                className = obj.getClass().getName();
            }
            String actual = this.sandbox.execute(className, method);
            if (actual != null) {
                return this.getMethodExecutor(obj, actual, args);
            }
        }
        return null;
    }

    public JexlPropertyGet getPropertyGet(Object obj, Object identifier, JexlInfo info) {
        String actual;
        if (obj != null && identifier != null && (actual = this.sandbox.read(obj.getClass().getName(), identifier.toString())) != null) {
            return super.getPropertyGet(obj, (Object)actual, info);
        }
        return null;
    }

    public JexlPropertySet getPropertySet(Object obj, Object identifier, Object arg, JexlInfo info) {
        String actual;
        if (obj != null && identifier != null && (actual = this.sandbox.write(obj.getClass().getName(), identifier.toString())) != null) {
            return super.getPropertySet(obj, (Object)actual, arg, info);
        }
        return null;
    }
}

