/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils.url;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericURLConnection
extends URLConnection {
    private static final Logger logger = LoggerFactory.getLogger(GenericURLConnection.class);
    private URL m_url;
    private static final String USERINFO_DELIMITER = ":";
    private static final String URL_QUERY_ARGS_DELIMITERS = "[&;]";
    private static final String KEY_VALUE_DELIMITER = "=";
    private static final String EMPTY_STRING = "";

    protected GenericURLConnection(URL url) {
        super(url);
        this.m_url = url;
    }

    protected String getUsername() {
        String userInfo = this.m_url.getUserInfo();
        if (userInfo != null) {
            if (userInfo.contains(USERINFO_DELIMITER)) {
                String[] userName = userInfo.split(USERINFO_DELIMITER);
                return userName[0];
            }
            logger.warn("Only user name without password configured. Return user info: '{}'", (Object)userInfo);
            return userInfo;
        }
        logger.warn("No credentials for URL connection configured.");
        return null;
    }

    protected String getPassword() {
        String userInfo = this.m_url.getUserInfo();
        if (userInfo != null) {
            if (userInfo.contains(USERINFO_DELIMITER)) {
                String[] userPass = userInfo.split(USERINFO_DELIMITER);
                return userPass[1];
            }
            logger.warn("Only user name without password configured. Return empty string as password");
            return EMPTY_STRING;
        }
        logger.warn("No credentials for URL connection configured.");
        return null;
    }

    protected Map<String, String> getQueryArgs() {
        return GenericURLConnection.getQueryStringParameters(this.m_url.getQuery());
    }

    public static Map<String, String> getQueryStringParameters(String queryString) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (queryString != null) {
            String[] queryArgs;
            String decodedQueryString = queryString;
            try {
                decodedQueryString = URLDecoder.decode(queryString, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Unsupported {} encoding for URL query string: '{}'. Error message: '{}'", new Object[]{StandardCharsets.UTF_8.name(), queryString, e.getMessage()});
            }
            String[] stringArray = queryArgs = decodedQueryString.split(URL_QUERY_ARGS_DELIMITERS);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String queryArg;
                String key = queryArg = stringArray[i];
                String value = EMPTY_STRING;
                if (queryArg.contains(KEY_VALUE_DELIMITER)) {
                    String[] keyValue = queryArg.split(KEY_VALUE_DELIMITER);
                    key = keyValue[0];
                    value = keyValue[1];
                }
                if (EMPTY_STRING.equals(key)) continue;
                hashMap.put(key, value);
                logger.debug("Key: '{}' : Value: '{}'", (Object)key, (Object)value);
            }
        }
        return hashMap;
    }
}

