/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd.rrdtool;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import org.opennms.core.utils.StringUtils;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdGraphDetails;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.rrdtool.JniGraphDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;

public abstract class AbstractJniRrdStrategy<D, F>
implements RrdStrategy<D, F> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJniRrdStrategy.class);
    private static final String IGNORABLE_LIBART_WARNING_STRING = "*** attempt to put segment in horiz list twice";
    private static final String IGNORABLE_LIBART_WARNING_REGEX = "\\*\\*\\* attempt to put segment in horiz list twice\r?\n?";

    public InputStream createGraph(String command, File workDir) throws IOException, RrdException {
        byte[] byteArray = this.createGraphAsByteArray(command, workDir);
        return new ByteArrayInputStream(byteArray);
    }

    private byte[] createGraphAsByteArray(String command, File workDir) throws IOException, RrdException {
        Process process;
        String[] commandArray = StringUtils.createCommandArray((String)command);
        try {
            process = Runtime.getRuntime().exec(commandArray, null, workDir);
        }
        catch (IOException e) {
            IOException newE = new IOException("IOException thrown while executing command '" + command + "' in " + workDir.getAbsolutePath() + ": " + e);
            newE.initCause(e);
            throw newE;
        }
        byte[] byteArray = FileCopyUtils.copyToByteArray((InputStream)process.getInputStream());
        String errors = FileCopyUtils.copyToString((Reader)new InputStreamReader(process.getErrorStream()));
        if (errors.length() > 0 && errors.contains(IGNORABLE_LIBART_WARNING_STRING)) {
            LOG.debug("Ignoring libart warning message in rrdtool stderr stream: {}", (Object)IGNORABLE_LIBART_WARNING_STRING);
            errors = errors.replaceAll(IGNORABLE_LIBART_WARNING_REGEX, "");
        }
        if (errors.length() > 0) {
            throw new RrdException(errors);
        }
        return byteArray;
    }

    public int getGraphLeftOffset() {
        return 65;
    }

    public int getGraphRightOffset() {
        return -30;
    }

    public int getGraphTopOffsetWithText() {
        return -75;
    }

    public String getStats() {
        return "";
    }

    public String getDefaultFileExtension() {
        return ".rrd";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RrdGraphDetails createGraphReturnDetails(String command, File workDir) throws IOException, RrdException {
        ByteArrayInputStream pngStream;
        String[] printLines;
        int height;
        int width;
        File pngFile = File.createTempFile("opennms.rrdtool.", ".png");
        command = command.replaceFirst("graph - ", "graph " + pngFile.getAbsolutePath() + " ");
        try {
            InputStream is = this.createGraph(command, workDir);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                String line = null;
                line = reader.readLine();
                if (line == null) {
                    throw new IOException("No output from the createGraph() command");
                }
                String[] s = line.split("x");
                width = Integer.parseInt(s[0]);
                height = Integer.parseInt(s[1]);
                ArrayList<String> printLinesList = new ArrayList<String>();
                while ((line = reader.readLine()) != null) {
                    printLinesList.add(line);
                }
                printLines = printLinesList.toArray(new String[printLinesList.size()]);
            }
            byte[] byteArray = FileCopyUtils.copyToByteArray((File)pngFile);
            pngStream = new ByteArrayInputStream(byteArray);
        }
        catch (Throwable e) {
            throw new RrdException("Can't execute command " + command, e);
        }
        finally {
            if (!pngFile.delete()) {
                LOG.warn("Could not delete file: {}", (Object)pngFile.getPath());
            }
        }
        return new JniGraphDetails(width, height, printLines, pngStream);
    }

    public void promoteEnqueuedFiles(Collection<String> rrdFiles) {
    }
}

