/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd.rrdtool;

import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.jrrd2.api.FetchResults;
import org.opennms.netmgt.rrd.jrrd2.api.JRrd2;
import org.opennms.netmgt.rrd.jrrd2.api.JRrd2Exception;
import org.opennms.netmgt.rrd.jrrd2.impl.JRrd2Jni;
import org.opennms.netmgt.rrd.rrdtool.AbstractJniRrdStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultithreadedJniRrdStrategy
extends AbstractJniRrdStrategy<CreateCommand, UpdateCommand> {
    private static final Logger LOG = LoggerFactory.getLogger(MultithreadedJniRrdStrategy.class);
    private final JRrd2 jrrd2 = new JRrd2Jni();
    private Properties m_configurationProperties;

    public Properties getConfigurationProperties() {
        return this.m_configurationProperties;
    }

    public void setConfigurationProperties(Properties configurationParameters) {
        this.m_configurationProperties = configurationParameters;
    }

    public void closeFile(UpdateCommand update) throws Exception {
        update.execute(this.jrrd2);
    }

    public CreateCommand createDefinition(String creator, String directory, String rrdName, int step, List<RrdDataSource> dataSources, List<String> rraList) throws Exception {
        String fileName;
        File f = new File(directory);
        if (!f.exists() && !f.mkdirs()) {
            LOG.warn("Could not make directory: {}", (Object)f.getPath());
        }
        if (new File(fileName = directory + File.separator + rrdName + this.getDefaultFileExtension()).exists()) {
            LOG.debug("createDefinition: filename [{}] already exists returning null as definition", (Object)fileName);
            return null;
        }
        int k = 0;
        String[] arguments = new String[dataSources.size() + rraList.size()];
        long start = System.currentTimeMillis() / 1000L - 10L;
        for (RrdDataSource dataSource : dataSources) {
            arguments[k++] = String.format("DS:%s:%s:%d:%s:%s", dataSource.getName(), dataSource.getType(), dataSource.getHeartBeat(), dataSource.getMin(), dataSource.getMax());
        }
        for (String rra : rraList) {
            arguments[k++] = rra;
        }
        return new CreateCommand(fileName, step, start, arguments);
    }

    public void createFile(CreateCommand createCommand) throws Exception {
        if (createCommand == null) {
            LOG.debug("createRRD: skipping RRD file");
            return;
        }
        LOG.debug("Executing: rrdtool {}", (Object)createCommand);
        createCommand.execute(this.jrrd2);
    }

    public UpdateCommand openFile(String fileName) throws Exception {
        return new UpdateCommand(fileName);
    }

    public void updateFile(UpdateCommand update, String owner, String data) throws Exception {
        update.append(data);
    }

    public Double fetchLastValue(String rrdFile, String ds, int interval) throws NumberFormatException, RrdException {
        return this.fetchLastValue(rrdFile, ds, "AVERAGE", interval);
    }

    public Double fetchLastValue(String rrdFile, String ds, String consolidationFunction, int interval) {
        try {
            long now = new Date().getTime();
            long start = now - (long)(interval / 1000);
            long end = now + (long)(interval / 1000);
            FetchResults results = this.jrrd2.fetch(rrdFile, consolidationFunction, start, end, 1L);
            String[] dsNames = results.getColumns();
            int dsIndex = 0;
            for (int i = 0; i < dsNames.length; ++i) {
                if (!dsNames[i].equals(ds)) continue;
                dsIndex = i;
            }
            double[][] dsValues = results.getValues();
            int numRows = dsValues[dsIndex].length;
            return dsValues[dsIndex][numRows - 1];
        }
        catch (JRrd2Exception e) {
            LOG.error("Fetch failed", (Throwable)e);
            return null;
        }
    }

    public Double fetchLastValueInRange(String rrdFile, String ds, int interval, int range) throws NumberFormatException, RrdException {
        try {
            long now = System.currentTimeMillis();
            long latestUpdateTime = (now - now % (long)interval) / 1000L;
            long earliestUpdateTime = (now - now % (long)interval - (long)range) / 1000L;
            FetchResults results = this.jrrd2.fetch(rrdFile, "AVERAGE", earliestUpdateTime, latestUpdateTime, 1L);
            String[] dsNames = results.getColumns();
            int dsIndex = 0;
            for (int i = 0; i < dsNames.length; ++i) {
                if (!dsNames[i].equals(ds)) continue;
                dsIndex = i;
            }
            double[][] dsValues = results.getValues();
            int numRows = dsValues[dsIndex].length;
            for (int i = numRows - 1; i >= 0; --i) {
                double value = dsValues[dsIndex][i];
                if (!Double.isNaN(value)) {
                    LOG.debug("fetchInRange: fetch successful: {}= {}", (Object)ds, (Object)value);
                    return value;
                }
                LOG.debug("fetchInRange: Got a NaN value - continuing back in time");
            }
            return dsValues[dsIndex][numRows - 1];
        }
        catch (JRrd2Exception e) {
            LOG.error("Fetch failed", (Throwable)e);
            return null;
        }
    }

    public static class UpdateCommand {
        private final String m_filename;
        private final List<String> m_arguments = new LinkedList<String>();

        public UpdateCommand(String filename) {
            this.m_filename = filename;
        }

        public void execute(JRrd2 jrrd2) throws JRrd2Exception {
            jrrd2.update(this.m_filename, null, this.m_arguments.toArray(new String[this.m_arguments.size()]));
        }

        public String toString() {
            return String.format("Filename: %s Arguments: %s", this.m_filename, this.m_arguments);
        }

        public void append(String argument) {
            this.m_arguments.add(argument);
        }
    }

    public static class CreateCommand {
        private final String m_filename;
        private final long m_step;
        private final long m_start;
        private final String[] m_argv;

        public CreateCommand(String filename, long step, long start, String[] argv) {
            this.m_filename = filename;
            this.m_step = step;
            this.m_start = start;
            this.m_argv = argv;
        }

        public String getFilename() {
            return this.m_filename;
        }

        public void execute(JRrd2 jrrd2) throws JRrd2Exception {
            jrrd2.create(this.m_filename, this.m_step, this.m_start, this.m_argv);
        }

        public String toString() {
            return String.format("Filename: %s, Argv: %s", this.m_filename, Arrays.toString(this.m_argv));
        }
    }
}

