/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.opennms.netmgt.provision.support.AsyncClientConversation;
import org.opennms.netmgt.provision.support.DetectFutureMinaImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseDetectorHandler<Request, Response>
extends IoHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(BaseDetectorHandler.class);
    private DetectFutureMinaImpl m_future;
    private AsyncClientConversation<Request, Response> m_conversation;

    public void setFuture(DetectFutureMinaImpl future) {
        this.m_future = future;
    }

    public DetectFutureMinaImpl getFuture() {
        return this.m_future;
    }

    public void sessionCreated(IoSession session) throws Exception {
    }

    public void sessionOpened(IoSession session) throws Exception {
        if (!this.getConversation().hasBanner() && this.getConversation().getRequest() != null) {
            Request request = this.getConversation().getRequest();
            session.write(request);
        }
    }

    public void sessionClosed(IoSession session) throws Exception {
        if (!this.getFuture().isDone()) {
            LOG.info("Session closed and detection is not complete. Setting service detection to false.");
            this.getFuture().setServiceDetected(false);
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        if (this.getConversation().hasBanner() && status == IdleStatus.READER_IDLE) {
            LOG.info("Session went idle without receiving banner. Setting service detection to false.");
            this.getFuture().setServiceDetected(false);
            session.close(true);
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        LOG.debug("Caught a Throwable in BaseDetectorHandler", cause);
        this.getFuture().setException(cause);
        session.close(true);
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        block8: {
            try {
                LOG.debug("Client Receiving: {}", (Object)message.toString().trim());
                if (this.getConversation().hasExchanges() && this.getConversation().validate(message)) {
                    Request request = this.getConversation().getRequest();
                    if (request != null) {
                        session.write(request);
                    } else if (request == null && this.getConversation().isComplete()) {
                        LOG.info("Conversation is complete and there are no more pending requests. Setting service detection to true.");
                        this.getFuture().setServiceDetected(true);
                        session.close(false);
                    } else {
                        LOG.info("Conversation is incomplete. Setting service detection to false.");
                        this.getFuture().setServiceDetected(false);
                        session.close(false);
                    }
                } else {
                    LOG.info("Conversation response was invalid. Setting service detection to false.");
                    this.getFuture().setServiceDetected(false);
                    session.close(false);
                }
            }
            catch (Throwable e) {
                if (session.isClosing()) break block8;
                session.close(true);
            }
        }
    }

    public void setConversation(AsyncClientConversation<Request, Response> conversation) {
        this.m_conversation = conversation;
    }

    public AsyncClientConversation<Request, Response> getConversation() {
        return this.m_conversation;
    }
}

