/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.opennms.netmgt.model.AckAction;
import org.opennms.netmgt.model.AckType;
import org.opennms.netmgt.model.Acknowledgeable;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;

@XmlRootElement(name="ack")
@Entity
@Table(name="acks")
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public class OnmsAcknowledgment {
    private Integer m_id;
    private Date m_ackTime;
    private String m_ackUser;
    private AckType m_ackType;
    private AckAction m_ackAction;
    private String m_log;
    private Integer m_refId;

    public OnmsAcknowledgment(Date time, String user) {
        this.m_ackTime = time == null ? new Date() : time;
        this.m_ackUser = user == null ? "admin" : user;
        this.m_ackType = AckType.UNSPECIFIED;
        this.m_ackAction = AckAction.ACKNOWLEDGE;
    }

    public OnmsAcknowledgment() {
        this(new Date(), "admin");
    }

    public OnmsAcknowledgment(String user) {
        this(new Date(), user);
    }

    public OnmsAcknowledgment(Date time) {
        this(time, "admin");
    }

    public OnmsAcknowledgment(Event e) throws ParseException {
        this(e.getTime(), "admin");
        List parms = e.getParmCollection();
        if (parms.size() <= 2) {
            throw new IllegalArgumentException("Event:" + e.getUei() + " has invalid paramenter list, requires ackType and refId.");
        }
        for (Parm parm : parms) {
            String parmValue = parm.getValue().getContent();
            if (!("ackAction".equals(parm.getParmName()) || "ackType".equals(parm.getParmName()) || "refId".equals(parm.getParmName()) || "ackUser".equals(parm.getParmName()) || "user".equals(parm.getParmName()))) {
                throw new IllegalArgumentException("Event parm: " + parm.getParmName() + ", is an invalid paramter");
            }
            if ("ackType".equals(parm.getParmName())) {
                if ("ALARM".equalsIgnoreCase(parmValue) || "NOTIFICATION".equalsIgnoreCase(parmValue)) {
                    this.m_ackType = "ALARM".equalsIgnoreCase(parmValue) ? AckType.ALARM : AckType.NOTIFICATION;
                    continue;
                }
                throw new IllegalArgumentException("Event parm: " + parm.getParmName() + ", has invalid value, requires: \"Alarm\" or \"Notification\".");
            }
            if ("refId".equals(parm.getParmName())) {
                this.m_refId = Integer.valueOf(parmValue);
                continue;
            }
            if ("ackUser".equals(parm.getParmName()) || "user".equals(parm.getParmName())) {
                this.m_ackUser = parmValue;
                continue;
            }
            if ("ACKNOWLEDGE".equalsIgnoreCase(parmValue)) {
                this.m_ackAction = AckAction.ACKNOWLEDGE;
                continue;
            }
            if ("ESCALATE".equalsIgnoreCase(parmValue)) {
                this.m_ackAction = AckAction.ESCALATE;
                continue;
            }
            if ("UNACKNOWLEDGE".equalsIgnoreCase(parmValue)) {
                this.m_ackAction = AckAction.UNACKNOWLEDGE;
                continue;
            }
            if ("CLEAR".equalsIgnoreCase(parmValue)) {
                this.m_ackAction = AckAction.CLEAR;
                continue;
            }
            this.m_ackAction = AckAction.UNSPECIFIED;
        }
    }

    public OnmsAcknowledgment(Acknowledgeable a) {
        this(a, "admin", new Date());
        if (a.getType() == AckType.ALARM && a.getAckUser() != null) {
            this.m_ackUser = a.getAckUser();
            this.m_ackTime = a.getAckTime();
        }
    }

    public OnmsAcknowledgment(Acknowledgeable a, String user) {
        this(a, user, new Date());
    }

    public OnmsAcknowledgment(Acknowledgeable a, String user, Date ackTime) {
        this();
        if (a == null) {
            throw new IllegalArgumentException("Acknowledgable is null.");
        }
        this.m_ackUser = user;
        this.m_ackTime = ackTime;
        this.m_ackType = a.getType();
        this.m_refId = a.getAckId();
    }

    @Id
    @Column(nullable=false)
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="ackTime", nullable=false)
    public Date getAckTime() {
        return this.m_ackTime;
    }

    public void setAckTime(Date time) {
        this.m_ackTime = time;
    }

    @Column(name="ackUser", length=64, nullable=false)
    public String getAckUser() {
        return this.m_ackUser;
    }

    public void setAckUser(String user) {
        this.m_ackUser = user;
    }

    @Column(name="ackType", nullable=false)
    public AckType getAckType() {
        return this.m_ackType;
    }

    public void setAckType(AckType ackType) {
        this.m_ackType = ackType;
    }

    @Column(name="refId")
    public Integer getRefId() {
        return this.m_refId;
    }

    public void setRefId(Integer refId) {
        this.m_refId = refId;
    }

    @Column(name="ackAction", nullable=false)
    public AckAction getAckAction() {
        return this.m_ackAction;
    }

    public void setAckAction(AckAction ackAction) {
        this.m_ackAction = ackAction;
    }

    @Column(name="log", nullable=true)
    public String getLog() {
        return this.m_log;
    }

    public void setLog(String log) {
        this.m_log = log;
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder("Acknowledgment ID:");
        bldr.append(this.m_id);
        bldr.append(" User:");
        bldr.append(this.m_ackUser);
        bldr.append(" Time:");
        bldr.append(this.m_ackTime);
        bldr.append(" AckType:");
        bldr.append((Object)this.m_ackType);
        bldr.append(" AckAction:");
        bldr.append((Object)this.m_ackAction);
        bldr.append(" Acknowledable ID:");
        bldr.append(this.m_refId);
        return bldr.toString();
    }
}

