/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.api;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AlarmCallbackStateTracker {
    private final Set<Integer> alarmsUpdatesById = new HashSet<Integer>();
    private final Set<String> alarmsUpdatesByReductionKey = new HashSet<String>();
    private final Set<Integer> deletedAlarmsByAlarmId = new HashSet<Integer>();
    private final Set<String> deletedAlarmsByReductionKey = new HashSet<String>();
    private final List<Set<?>> sets = Arrays.asList(this.alarmsUpdatesById, this.alarmsUpdatesByReductionKey, this.deletedAlarmsByAlarmId, this.deletedAlarmsByReductionKey);
    private boolean trackAlarms = false;

    public synchronized void startTrackingAlarms() {
        this.trackAlarms = true;
    }

    public synchronized void trackNewOrUpdatedAlarm(int alarmId, String reductionKey) {
        if (!this.trackAlarms) {
            return;
        }
        this.alarmsUpdatesById.add(alarmId);
        this.alarmsUpdatesByReductionKey.add(reductionKey);
    }

    public synchronized void trackDeletedAlarm(int alarmId, String reductionKey) {
        if (!this.trackAlarms) {
            return;
        }
        this.deletedAlarmsByAlarmId.add(alarmId);
        this.deletedAlarmsByReductionKey.add(reductionKey);
    }

    public synchronized void resetStateAndStopTrackingAlarms() {
        this.trackAlarms = false;
        this.sets.forEach(Set::clear);
    }

    public synchronized boolean wasAlarmWithIdUpdated(int alarmId) {
        return this.alarmsUpdatesById.contains(alarmId);
    }

    public synchronized boolean wasAlarmWithIdDeleted(int alarmId) {
        return this.deletedAlarmsByAlarmId.contains(alarmId);
    }

    public synchronized boolean wasAlarmWithReductionKeyUpdated(String reductionKey) {
        return this.alarmsUpdatesByReductionKey.contains(reductionKey);
    }

    public synchronized boolean wasAlarmWithReductionKeyDeleted(String reductionKey) {
        return this.deletedAlarmsByReductionKey.contains(reductionKey);
    }

    public Set<Integer> getUpdatedAlarmIds() {
        return ImmutableSet.copyOf(this.alarmsUpdatesById);
    }
}

