/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.topo;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.browsers.ContentType;
import org.opennms.features.topology.api.browsers.SelectionChangedListener;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.BackendGraph;
import org.opennms.features.topology.api.topo.DefaultTopologyProviderInfo;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.TopologyProviderInfo;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.api.topo.simple.SimpleGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTopologyProvider
implements GraphProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTopologyProvider.class);
    protected final BackendGraph graph;
    protected TopologyProviderInfo topologyProviderInfo = new DefaultTopologyProviderInfo();

    public AbstractTopologyProvider(String namespace) {
        this(new SimpleGraph(Objects.requireNonNull(namespace)));
    }

    public AbstractTopologyProvider(BackendGraph graph) {
        this.graph = Objects.requireNonNull(graph);
        LOG.debug("Creating a new {} with namespace {}", (Object)this.getClass().getSimpleName(), (Object)graph.getNamespace());
    }

    @Override
    public String getNamespace() {
        return this.graph.getNamespace();
    }

    @Override
    public TopologyProviderInfo getTopologyProviderInfo() {
        return this.topologyProviderInfo;
    }

    public void setTopologyProviderInfo(TopologyProviderInfo topologyProviderInfo) {
        this.topologyProviderInfo = topologyProviderInfo;
    }

    @Override
    public BackendGraph getCurrentGraph() {
        return this.graph;
    }

    @Override
    public abstract void refresh();

    protected static SelectionChangedListener.Selection getSelection(String namespace, List<VertexRef> selectedVertices, ContentType type) {
        Set<Integer> nodeIds = selectedVertices.stream().filter(v -> namespace.equals(v.getNamespace())).filter(v -> v instanceof AbstractVertex).map(v -> (AbstractVertex)v).map(v -> v.getNodeID()).filter(nodeId -> nodeId != null).collect(Collectors.toSet());
        if (type == ContentType.Alarm) {
            return new SelectionChangedListener.AlarmNodeIdSelection(nodeIds);
        }
        if (type == ContentType.Node) {
            return new SelectionChangedListener.IdSelection<Integer>(nodeIds);
        }
        return SelectionChangedListener.Selection.NONE;
    }
}

