/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.support;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;
import org.opennms.features.topology.api.ConfigurableIconRepository;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.LoggerFactory;

public class DefaultIconRepository
implements ConfigurableIconRepository,
ManagedService {
    private final Map<String, String> m_iconMap = Maps.newHashMap();

    @Override
    public boolean contains(String iconKey) {
        if ("service.pid".equals(iconKey) || "felix.fileinstall.filename".equals(iconKey)) {
            return false;
        }
        return this.m_iconMap.containsKey(iconKey);
    }

    @Override
    public String getSVGIconId(String iconKey) {
        return this.m_iconMap.get(iconKey);
    }

    @Override
    public void addIconMapping(String iconKey, String iconId) {
        this.m_iconMap.put(iconKey, iconId);
    }

    @Override
    public void removeIconMapping(String iconKey) {
        this.m_iconMap.remove(iconKey);
    }

    @Override
    public void save() {
        String opennmsHomeStr = System.getProperty("opennms.home", "");
        String propertiesFilename = this.m_iconMap.get("service.pid") + ".cfg";
        File configFile = Paths.get(opennmsHomeStr, "etc", propertiesFilename).toFile();
        try {
            Properties properties = new Properties();
            properties.putAll(this.m_iconMap);
            properties.remove("service.pid");
            properties.remove("felix.fileinstall.filename");
            properties.store(new FileOutputStream(configFile), "");
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Could not write config file {}", (Object)configFile, (Object)e);
        }
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        if (properties != null && !properties.equals(this.m_iconMap)) {
            this.m_iconMap.clear();
            for (String key : Collections.list(properties.keys())) {
                String v = (String)properties.get(key);
                this.m_iconMap.put(key, v.trim());
            }
        }
    }
}

