/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.topologies.service.api;

import java.util.Objects;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyProtocol;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyRef;

public class OnmsTopologyMessage {
    private final OnmsTopologyRef m_messagebody;
    private final TopologyMessageStatus m_messagestatus;
    private final OnmsTopologyProtocol m_protocol;

    public static OnmsTopologyMessage update(OnmsTopologyRef messagebody, OnmsTopologyProtocol protocol) {
        Objects.requireNonNull(messagebody);
        Objects.requireNonNull(protocol);
        return new OnmsTopologyMessage(messagebody, protocol, TopologyMessageStatus.UPDATE);
    }

    public static OnmsTopologyMessage delete(OnmsTopologyRef messagebody, OnmsTopologyProtocol protocol) {
        Objects.requireNonNull(messagebody);
        Objects.requireNonNull(protocol);
        return new OnmsTopologyMessage(messagebody, protocol, TopologyMessageStatus.DELETE);
    }

    private <T extends OnmsTopologyRef> OnmsTopologyMessage(T messagebody, OnmsTopologyProtocol protocol, TopologyMessageStatus messagestatus) {
        this.m_messagebody = messagebody;
        this.m_messagestatus = messagestatus;
        this.m_protocol = protocol;
    }

    public OnmsTopologyRef getMessagebody() {
        return this.m_messagebody;
    }

    public TopologyMessageStatus getMessagestatus() {
        return this.m_messagestatus;
    }

    public OnmsTopologyProtocol getProtocol() {
        return this.m_protocol;
    }

    public static enum TopologyMessageStatus {
        UPDATE,
        DELETE;

    }
}

