/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.status.api.node;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.features.status.api.StatusEntity;
import org.opennms.features.status.api.StatusEntityWrapper;
import org.opennms.features.status.api.StatusSummary;
import org.opennms.features.status.api.node.NodeQuery;
import org.opennms.features.status.api.node.NodeStatusCalculator;
import org.opennms.features.status.api.node.strategy.NodeStatusCalculationStrategy;
import org.opennms.features.status.api.node.strategy.NodeStatusCalculatorConfig;
import org.opennms.features.status.api.node.strategy.Status;
import org.opennms.netmgt.config.GroupDao;
import org.opennms.netmgt.config.groups.Group;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.springframework.security.AclUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class NodeStatusService {
    @Autowired
    private NodeDao nodeDao;
    @Autowired
    private CategoryDao categoryDao;
    @Autowired
    private GroupDao groupDao;
    @Autowired
    private NodeStatusCalculator statusCalculator;

    public StatusSummary getSummary(NodeStatusCalculationStrategy strategy) {
        NodeStatusCalculatorConfig config = new NodeStatusCalculatorConfig();
        config.setSeverities(Lists.newArrayList((Object[])new OnmsSeverity[]{OnmsSeverity.NORMAL, OnmsSeverity.WARNING, OnmsSeverity.MINOR, OnmsSeverity.MAJOR, OnmsSeverity.CRITICAL}));
        config.setCalculationStrategy(strategy);
        Map<OnmsSeverity, Long> statusOverviewMap = this.statusCalculator.calculateStatusOverview(this.applyWebAcls(config));
        long totalCount = this.nodeDao.countAll();
        return new StatusSummary(statusOverviewMap, totalCount);
    }

    private NodeStatusCalculatorConfig applyWebAcls(NodeStatusCalculatorConfig config) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return config;
        }
        if (!AclUtils.shouldFilter((Collection)authentication.getAuthorities())) {
            return config;
        }
        String username = authentication.getName();
        List groups = this.groupDao.findGroupsForUser(username);
        HashSet categories = new HashSet();
        for (Group group : groups) {
            categories.addAll(this.categoryDao.getCategoriesWithAuthorizedGroup(group.getName()));
        }
        config.setNodeIds(this.nodeDao.findAllByCategoryList(categories).stream().map(n -> n.getId()).collect(Collectors.toList()));
        return config;
    }

    public int count(NodeQuery query) {
        NodeStatusCalculatorConfig config = this.buildFrom(query);
        config.prepareForCounting();
        return this.statusCalculator.countStatus(config);
    }

    public List<StatusEntity<OnmsNode>> getStatus(NodeQuery query) {
        NodeStatusCalculatorConfig config = this.buildFrom(query);
        Status status = this.statusCalculator.calculateStatus(config);
        List<OnmsNode> nodes = this.getNodes(status.getIds());
        Map<Integer, OnmsNode> nodeIdMap = nodes.stream().collect(Collectors.toMap(n -> n.getId(), n -> n));
        return status.getIds().stream().map(nodeId -> {
            OnmsSeverity nodeStatus = status.getSeverity((int)nodeId);
            OnmsNode node = (OnmsNode)nodeIdMap.get(nodeId);
            if (nodeStatus == null) {
                throw new IllegalStateException("nodeStatus should not be null");
            }
            if (node == null) {
                throw new IllegalStateException("node should not be null");
            }
            return new StatusEntityWrapper<OnmsNode>(node, nodeStatus);
        }).collect(Collectors.toList());
    }

    private List<OnmsNode> getNodes(List<Integer> ids) {
        if (ids == null || ids.isEmpty()) {
            return new ArrayList<OnmsNode>();
        }
        List nodes = this.nodeDao.findMatching(new CriteriaBuilder(OnmsNode.class).in("id", ids).toCriteria());
        return nodes;
    }

    private NodeStatusCalculatorConfig buildFrom(NodeQuery query) {
        NodeStatusCalculatorConfig config = new NodeStatusCalculatorConfig();
        config.setCalculationStrategy(query.getStatusCalculationStrategy());
        if (query.getSeverityFilter() != null && query.getSeverityFilter().getSeverities() != null) {
            config.setSeverities(query.getSeverityFilter().getSeverities());
        }
        if (query.getParameters().getOffset() != null) {
            config.setOffset(query.getParameters().getOffset());
        }
        if (query.getParameters().getLimit() != null) {
            config.setLimit(query.getParameters().getLimit());
        }
        if (query.getParameters().getOrder() != null) {
            config.setOrder(query.getParameters().getOrder());
        }
        return this.applyWebAcls(config);
    }
}

