/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.status.api.bsm;

import java.util.List;
import java.util.stream.Collectors;
import org.opennms.features.status.api.Query;
import org.opennms.features.status.api.StatusEntity;
import org.opennms.features.status.api.StatusEntityWrapper;
import org.opennms.features.status.api.StatusSummary;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.BusinessServiceSearchCriteriaBuilder;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.utils.QueryParameters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusinessServiceStatusService {
    @Autowired
    private BusinessServiceManager businessServiceManager;

    public int count(Query query) {
        BusinessServiceSearchCriteriaBuilder criteria = this.buildFrom(query);
        criteria.prepareForCounting();
        List services = criteria.apply(this.businessServiceManager, this.businessServiceManager.getAllBusinessServices());
        return services.size();
    }

    public StatusSummary getSummary() {
        List businessServices = this.businessServiceManager.getAllBusinessServices();
        List<OnmsSeverity> severityList = businessServices.stream().map(bs -> OnmsSeverity.get((String)bs.getOperationalStatus().getLabel())).collect(Collectors.toList());
        long totalCount = businessServices.size();
        return new StatusSummary(severityList, totalCount);
    }

    public List<StatusEntity<BusinessService>> getStatus(Query query) {
        BusinessServiceSearchCriteriaBuilder criteria = this.buildFrom(query);
        List services = criteria.apply(this.businessServiceManager, this.businessServiceManager.getAllBusinessServices());
        List<StatusEntity<BusinessService>> mappedServices = services.stream().map(eachService -> new StatusEntityWrapper<BusinessService>((BusinessService)eachService, OnmsSeverity.get((String)eachService.getOperationalStatus().getLabel()))).collect(Collectors.toList());
        return mappedServices;
    }

    private BusinessServiceSearchCriteriaBuilder buildFrom(Query query) {
        BusinessServiceSearchCriteriaBuilder criteriaBuilder = new BusinessServiceSearchCriteriaBuilder();
        if (query.getSeverityFilter() != null && !query.getSeverityFilter().getSeverities().isEmpty()) {
            List statusList = query.getSeverityFilter().getSeverities().stream().map(eachSeverity -> Status.of((String)eachSeverity.name())).collect(Collectors.toList());
            criteriaBuilder.inSeverity(statusList);
        } else {
            criteriaBuilder.greaterOrEqualSeverity(Status.NORMAL);
        }
        if (query.getParameters().getOrder() != null) {
            QueryParameters.Order order = query.getParameters().getOrder();
            criteriaBuilder.order(order.getColumn(), !order.isDesc());
        }
        if (query.getParameters().getLimit() != null) {
            criteriaBuilder.limit(query.getParameters().getLimit().intValue());
        }
        if (query.getParameters().getOffset() != null) {
            criteriaBuilder.offset(query.getParameters().getOffset().intValue());
        }
        return criteriaBuilder;
    }
}

