/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.scv.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScvUtils {
    public static final String KEYSTORE_KEY_PROPERTY = "org.opennms.features.scv.jceks.key";
    public static final Logger LOG = LoggerFactory.getLogger(ScvUtils.class);
    public static final String OPENNMS_PROPERTIES_D_NAME = "opennms.properties.d";
    public static final String OPENNMS_PROPERTIES_NAME = "opennms.properties";

    public static Properties loadScvProperties(String opennmsHome) {
        Properties onmsProperties = new Properties();
        String keyStoreKey = System.getProperty(KEYSTORE_KEY_PROPERTY);
        if (keyStoreKey != null && !keyStoreKey.isEmpty()) {
            onmsProperties.setProperty(KEYSTORE_KEY_PROPERTY, keyStoreKey);
        } else if (opennmsHome != null && !opennmsHome.isEmpty()) {
            ScvUtils.loadProperties(Path.of(opennmsHome, "etc", OPENNMS_PROPERTIES_D_NAME).toString(), onmsProperties);
            ScvUtils.loadProperties(Path.of(opennmsHome, "etc", OPENNMS_PROPERTIES_NAME).toString(), onmsProperties);
        }
        return onmsProperties;
    }

    private static void loadProperties(String path, Properties onmsProperties) {
        File fileOrDir = new File(path);
        if (!fileOrDir.exists()) {
            LOG.info(" Path does not exist: " + path);
            return;
        }
        if (fileOrDir.isFile() && path.endsWith(".properties")) {
            ScvUtils.loadSingleFile(fileOrDir, onmsProperties);
        } else if (fileOrDir.isDirectory()) {
            Optional.ofNullable(fileOrDir.listFiles((dir, name) -> name.endsWith(".properties"))).map(Arrays::stream).orElse(Stream.empty()).forEach(file -> ScvUtils.loadSingleFile(file, onmsProperties));
        } else {
            LOG.info(" Not a valid .properties file or directory: " + path);
        }
    }

    private static void loadSingleFile(File file, Properties onmsProperties) {
        try (FileInputStream fis = new FileInputStream(file);){
            Properties props = new Properties();
            props.load(fis);
            props.stringPropertyNames().stream().filter(key -> !onmsProperties.containsKey(key)).forEach(key -> onmsProperties.setProperty((String)key, props.getProperty((String)key)));
        }
        catch (IOException e) {
            LOG.info("Failed to load properties from: " + file.getName());
        }
    }
}

