/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.geocoder;

import org.opennms.features.geocoder.Coordinates;
import org.opennms.features.geocoder.GeocoderException;

public class GeocoderResult {
    private String address;
    private Coordinates coordinates;
    private Throwable throwable;

    private GeocoderResult() {
    }

    public boolean hasError() {
        return this.throwable != null;
    }

    public boolean isEmpty() {
        return this.coordinates == null;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    public String getAddress() {
        return this.address;
    }

    private void setAddress(String address) {
        this.address = address;
    }

    private void setCoordinates(Coordinates coordinates) {
        this.coordinates = coordinates;
    }

    private void setError(String errorMessage) {
        this.setError(new GeocoderException(errorMessage));
    }

    private void setError(Throwable throwable) {
        this.throwable = throwable;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder success(String address, double lng, double lat) {
        return new Builder().withAddress(address).withCoordinates(lng, lat);
    }

    public static Builder noResult(String address) {
        return new Builder().withAddress(address).noResult();
    }

    public static Builder error(String errorMessage) {
        return new Builder().withError(errorMessage);
    }

    public static Builder error(Exception exception) {
        return new Builder().withError(exception);
    }

    public static class Builder {
        final GeocoderResult result = new GeocoderResult();

        private Builder() {
        }

        public Builder noResult() {
            if (this.result.getAddress() != null) {
                this.result.setError(String.format("No results found for address '%s'", this.result.getAddress()));
            } else {
                this.result.setError("No results found for address");
            }
            return this;
        }

        public Builder withAddress(String address) {
            this.result.setAddress(address);
            return this;
        }

        public Builder withCoordinates(double lng, double lat) {
            this.result.setCoordinates(new Coordinates(lng, lat));
            return this;
        }

        public Builder withError(String errorMessage) {
            this.result.setError(errorMessage);
            return this;
        }

        public Builder withError(Throwable t) {
            this.result.setError(t);
            return this;
        }

        public GeocoderResult build() {
            return this.result;
        }
    }
}

