/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.events.api.model;

import java.util.Objects;
import org.opennms.netmgt.events.api.model.ITticket;

public final class ImmutableTticket
implements ITticket {
    private final String content;
    private final String state;

    private ImmutableTticket(Builder builder) {
        this.content = builder.content;
        this.state = builder.state;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(ITticket tticket) {
        return new Builder(tticket);
    }

    public static ITticket immutableCopy(ITticket tticket) {
        if (tticket == null || tticket instanceof ImmutableTticket) {
            return tticket;
        }
        return ImmutableTticket.newBuilderFrom(tticket).build();
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public String getState() {
        return this.state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableTticket that = (ImmutableTticket)o;
        return Objects.equals(this.content, that.content) && Objects.equals(this.state, that.state);
    }

    public int hashCode() {
        return Objects.hash(this.content, this.state);
    }

    public String toString() {
        return "ImmutableTticket{content='" + this.content + "', state='" + this.state + "'}";
    }

    public static final class Builder {
        private String content;
        private String state;

        private Builder() {
        }

        public Builder(ITticket tticket) {
            this.content = tticket.getContent();
            this.state = tticket.getState();
        }

        public Builder setContent(String content) {
            this.content = content;
            return this;
        }

        public Builder setState(String state) {
            this.state = state;
            return this;
        }

        public ImmutableTticket build() {
            return new ImmutableTticket(this);
        }
    }
}

