/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.events.api;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.opennms.netmgt.events.api.EventDatetimeFormatter;

public class LegacyDatetimeFormatter
implements EventDatetimeFormatter {
    public static final ThreadLocal<DateFormat> FORMATTER_FULL = ThreadLocal.withInitial(() -> {
        int timeFormat = 0;
        String language = Locale.getDefault().getLanguage();
        if (language.equals(Locale.FRANCE.getLanguage()) || language.equals(Locale.GERMANY.getLanguage())) {
            timeFormat = 1;
        }
        DateFormat formatter = DateFormat.getDateTimeInstance(0, timeFormat);
        formatter.setLenient(true);
        return formatter;
    });
    public static final ThreadLocal<DateFormat> FORMATTER_LONG = ThreadLocal.withInitial(() -> {
        DateFormat formatter = DateFormat.getDateTimeInstance(0, 1);
        formatter.setLenient(true);
        return formatter;
    });
    public static final ThreadLocal<DateFormat> FORMATTER_LONG_GMT = ThreadLocal.withInitial(() -> {
        DateFormat formatter = DateFormat.getDateTimeInstance(0, 1);
        formatter.setLenient(true);
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        return formatter;
    });
    public static final ThreadLocal<DateFormat> FORMATTER_CUSTOM = ThreadLocal.withInitial(() -> {
        SimpleDateFormat formatter = new SimpleDateFormat("EEEEE, d MMMMM yyyy k:mm:ss 'o''clock' z", Locale.ENGLISH);
        formatter.setLenient(true);
        return formatter;
    });
    public static final ThreadLocal<DateFormat> FORMATTER_DEFAULT = ThreadLocal.withInitial(() -> {
        DateFormat formatter = DateFormat.getDateTimeInstance();
        formatter.setLenient(true);
        return formatter;
    });
    private static final List<ThreadLocal<DateFormat>> preferredOrder = Arrays.asList(FORMATTER_LONG, FORMATTER_CUSTOM, FORMATTER_FULL, FORMATTER_DEFAULT);

    @Override
    public Date parse(String dateString) throws ParseException {
        if (dateString == null) {
            throw new ParseException("time was null!", -1);
        }
        String noUtc = dateString.replaceAll("UTC$", "GMT");
        ParseException e = null;
        for (String attempt : Arrays.asList(dateString, noUtc)) {
            for (ThreadLocal<DateFormat> formatter : preferredOrder) {
                DateFormat dateFormatter = formatter.get();
                try {
                    return dateFormatter.parse(attempt);
                }
                catch (ParseException pe) {
                    if (e != null) continue;
                    e = pe;
                }
            }
        }
        ParseException thrown = null;
        try {
            return Date.from(ZonedDateTime.parse(dateString).toInstant());
        }
        catch (DateTimeParseException dtpe) {
            thrown = new ParseException("failed to parse " + dateString + " as any legacy format; giving up", dtpe.getErrorIndex());
        }
        catch (Exception isoe) {
            thrown = new ParseException("failed to parse " + dateString + " as any legacy format; giving up", 0);
        }
        thrown.initCause(e);
        throw thrown;
    }

    @Override
    public String format(Date date) {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(date.toInstant().atZone(ZoneId.systemDefault()));
    }
}

