/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.model;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.Type;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.OnmsNode;

@Entity
@Table(name="ospfLink")
@Filter(name="authorizedOnly", condition="exists (select distinct x.nodeid from node x join category_node cn on x.nodeid = cn.nodeid join category_group cg on cn.categoryId = cg.categoryId where x.nodeid = nodeid and cg.groupId in (:userGroups))")
public class OspfLink
implements Serializable {
    private static final long serialVersionUID = 3798160983917807494L;
    private Integer m_id;
    private OnmsNode m_node;
    private InetAddress m_ospfIpAddr;
    private InetAddress m_ospfIpMask;
    private Integer m_ospfIfIndex;
    private Integer m_ospfAddressLessIndex;
    private InetAddress m_ospfRemRouterId;
    private InetAddress m_ospfRemIpAddr;
    private Integer m_ospfRemAddressLessIndex;
    private Date m_ospfLinkCreateTime = new Date();
    private Date m_ospfLinkLastPollTime;

    @Id
    @Column(nullable=false)
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @Type(type="org.opennms.netmgt.model.InetAddressUserType")
    @Column(name="ospfIpAddr")
    public InetAddress getOspfIpAddr() {
        return this.m_ospfIpAddr;
    }

    @Type(type="org.opennms.netmgt.model.InetAddressUserType")
    @Column(name="ospfIpMask")
    public InetAddress getOspfIpMask() {
        return this.m_ospfIpMask;
    }

    @Column(name="ospfAddressLessIndex")
    public Integer getOspfAddressLessIndex() {
        return this.m_ospfAddressLessIndex;
    }

    @Column(name="ospfIfIndex")
    public Integer getOspfIfIndex() {
        return this.m_ospfIfIndex;
    }

    @Type(type="org.opennms.netmgt.model.InetAddressUserType")
    @Column(name="ospfRemRouterId", nullable=false)
    public InetAddress getOspfRemRouterId() {
        return this.m_ospfRemRouterId;
    }

    @Type(type="org.opennms.netmgt.model.InetAddressUserType")
    @Column(name="ospfRemIpAddr", nullable=false)
    public InetAddress getOspfRemIpAddr() {
        return this.m_ospfRemIpAddr;
    }

    @Column(name="ospfRemAddressLessIndex", nullable=false)
    public Integer getOspfRemAddressLessIndex() {
        return this.m_ospfRemAddressLessIndex;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="ospfLinkCreateTime", nullable=false)
    public Date getOspfLinkCreateTime() {
        return this.m_ospfLinkCreateTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="ospfLinkLastPollTime", nullable=false)
    public Date getOspfLinkLastPollTime() {
        return this.m_ospfLinkLastPollTime;
    }

    public void setOspfIpAddr(InetAddress ospfIpAddr) {
        this.m_ospfIpAddr = ospfIpAddr;
    }

    public void setOspfIpMask(InetAddress ospfIpMask) {
        this.m_ospfIpMask = ospfIpMask;
    }

    public void setOspfIfIndex(Integer ospfIfIndex) {
        this.m_ospfIfIndex = ospfIfIndex;
    }

    public void setOspfAddressLessIndex(Integer ospfAddressLessIndex) {
        this.m_ospfAddressLessIndex = ospfAddressLessIndex;
    }

    public void setOspfRemRouterId(InetAddress ospfRemRouterId) {
        this.m_ospfRemRouterId = ospfRemRouterId;
    }

    public void setOspfRemIpAddr(InetAddress ospfRemIpAddr) {
        this.m_ospfRemIpAddr = ospfRemIpAddr;
    }

    public void setOspfRemAddressLessIndex(Integer ospfRemAddressLessIndex) {
        this.m_ospfRemAddressLessIndex = ospfRemAddressLessIndex;
    }

    public void setOspfLinkCreateTime(Date ospfLinkCreateTime) {
        this.m_ospfLinkCreateTime = ospfLinkCreateTime;
    }

    public void setOspfLinkLastPollTime(Date ospfLinkLastPollTime) {
        this.m_ospfLinkLastPollTime = ospfLinkLastPollTime;
    }

    public String toString() {
        return "ospflink: nodeid:[" + this.getNode().getId() + "]: id/mask/ifindex/addressless:[" + InetAddressUtils.str((InetAddress)this.getOspfIpAddr()) + "/" + InetAddressUtils.str((InetAddress)this.getOspfIpMask()) + "/" + this.getOspfIfIndex() + "/" + this.getOspfAddressLessIndex() + "]: rem router id/ip/addressless:[" + InetAddressUtils.str((InetAddress)this.getOspfRemRouterId()) + "/" + InetAddressUtils.str((InetAddress)this.getOspfRemIpAddr()) + "/" + this.getOspfRemAddressLessIndex() + "]";
    }

    public void merge(OspfLink link) {
        if (link == null) {
            return;
        }
        this.setOspfIpAddr(link.getOspfIpAddr());
        this.setOspfIpMask(link.getOspfIpMask());
        this.setOspfIfIndex(link.getOspfIfIndex());
        this.setOspfAddressLessIndex(link.getOspfAddressLessIndex());
        this.setOspfRemRouterId(link.getOspfRemRouterId());
        this.setOspfRemIpAddr(link.getOspfRemIpAddr());
        this.setOspfRemAddressLessIndex(link.getOspfRemAddressLessIndex());
        this.setOspfLinkLastPollTime(link.getOspfLinkCreateTime());
    }
}

