/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.topologies.service.api;

import java.util.Objects;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyAbstractRef;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyRef;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyVertex;
import org.opennms.netmgt.topologies.service.api.TopologyVisitor;

public class OnmsTopologyPort
extends OnmsTopologyAbstractRef
implements OnmsTopologyRef {
    private final OnmsTopologyVertex m_vertex;
    private final Integer m_index;
    private Integer m_ifindex;
    private String m_ifname;
    private String m_addr;
    private String m_speed;

    public static OnmsTopologyPort create(String id, OnmsTopologyVertex vertex, Integer index) {
        Objects.requireNonNull(id, "Cannot create port, id is null");
        Objects.requireNonNull(vertex, "Cannot create port, vertex is null");
        if (index != null) {
            return new OnmsTopologyPort(id, vertex, index);
        }
        return new OnmsTopologyPort(id, vertex, -1);
    }

    private OnmsTopologyPort(String id, OnmsTopologyVertex vertex, Integer index) {
        super(id);
        this.m_vertex = vertex;
        this.m_index = index;
    }

    public String getAddr() {
        return this.m_addr;
    }

    public void setAddr(String addr) {
        this.m_addr = addr;
    }

    public String getSpeed() {
        return this.m_speed;
    }

    public void setSpeed(String speed) {
        this.m_speed = speed;
    }

    public OnmsTopologyVertex getVertex() {
        return this.m_vertex;
    }

    public Integer getIndex() {
        return this.m_index;
    }

    public Integer getIfindex() {
        return this.m_ifindex;
    }

    public void setIfindex(Integer ifindex) {
        this.m_ifindex = ifindex;
    }

    public String getIfname() {
        return this.m_ifname;
    }

    public void setIfname(String ifname) {
        this.m_ifname = ifname;
    }

    @Override
    public void accept(TopologyVisitor v) {
        v.visit(this);
    }
}

