/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.api;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.model.IpInterfaceTopologyEntity;
import org.springframework.util.Assert;

public class SubNetwork {
    private final InetAddress m_network;
    private final InetAddress m_netmask;
    private final Map<Integer, Set<InetAddress>> m_nodeInterfaceMap = new HashMap<Integer, Set<InetAddress>>();

    public static SubNetwork createSubNetwork(IpInterfaceTopologyEntity ip) throws IllegalArgumentException {
        Assert.notNull((Object)ip);
        return SubNetwork.createSubNetwork(ip.getNodeId(), ip.getIpAddress(), ip.getNetMask());
    }

    public static SubNetwork createSubNetwork(Integer nodeid, InetAddress ip, InetAddress mask) throws IllegalArgumentException {
        Assert.notNull((Object)ip);
        Assert.notNull((Object)mask);
        Assert.notNull((Object)nodeid);
        return new SubNetwork(nodeid, ip, mask);
    }

    private SubNetwork(Integer nodeid, InetAddress ip, InetAddress netmask) {
        this.m_network = InetAddressUtils.getNetwork((InetAddress)ip, (InetAddress)netmask);
        this.m_netmask = netmask;
        this.m_nodeInterfaceMap.put(nodeid, new HashSet());
        this.m_nodeInterfaceMap.get(nodeid).add(ip);
    }

    public InetAddress getNetwork() {
        return this.m_network;
    }

    public InetAddress getNetmask() {
        return this.m_netmask;
    }

    public String getCidr() {
        return this.m_network.getHostAddress() + "/" + InetAddressUtils.convertInetAddressMaskToCidr((InetAddress)this.m_netmask);
    }

    public int getNetworkPrefix() {
        return InetAddressUtils.convertInetAddressMaskToCidr((InetAddress)this.m_netmask);
    }

    public boolean isIpV4Subnetwork() {
        return this.m_network.getAddress().length == 4;
    }

    public Set<Integer> getNodeIds() {
        return this.m_nodeInterfaceMap.keySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubNetwork that = (SubNetwork)o;
        if (!this.m_network.equals(that.m_network)) {
            return false;
        }
        return this.m_netmask.equals(that.m_netmask);
    }

    public int hashCode() {
        int result = this.m_network.hashCode();
        result = 31 * result + this.m_netmask.hashCode();
        return result;
    }

    public boolean add(Integer nodeid, InetAddress ip) {
        if (this.isInRange(ip)) {
            if (!this.m_nodeInterfaceMap.containsKey(nodeid)) {
                this.m_nodeInterfaceMap.put(nodeid, new HashSet());
            }
            return this.m_nodeInterfaceMap.get(nodeid).add(ip);
        }
        return false;
    }

    public boolean remove(Integer nodeid, InetAddress ip) {
        if (this.m_nodeInterfaceMap.containsKey(nodeid)) {
            boolean removed = this.m_nodeInterfaceMap.get(nodeid).remove(ip);
            if (removed && this.m_nodeInterfaceMap.get(nodeid).size() == 0) {
                this.m_nodeInterfaceMap.remove(nodeid);
            }
            return removed;
        }
        return false;
    }

    public boolean isInRange(InetAddress ip) {
        return InetAddressUtils.inSameNetwork((InetAddress)ip, (InetAddress)this.m_network, (InetAddress)this.m_netmask);
    }

    public boolean hasDuplicatedAddress() {
        HashSet<InetAddress> ips = new HashSet<InetAddress>();
        for (Set<InetAddress> addresses : this.m_nodeInterfaceMap.values()) {
            for (InetAddress address : addresses) {
                if (ips.contains(address)) {
                    return true;
                }
                ips.add(address);
            }
        }
        return false;
    }

    public String toString() {
        return "SubNetwork{ " + this.getCidr() + ". NodeMap: " + this.m_nodeInterfaceMap + "}";
    }
}

