/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.util;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Consumer;
import org.opennms.core.utils.StringUtils;
import org.opennms.netmgt.events.api.EventDatabaseConstants;
import org.opennms.netmgt.xml.event.Snmp;

public abstract class SnmpInfo {
    public static String format(Snmp info, int maxlen) {
        if (info == null) {
            return null;
        }
        StringBuilder snmpStr = new StringBuilder(info.getId());
        if (info.getIdtext() != null) {
            snmpStr.append(',').append(EventDatabaseConstants.escape((String)info.getIdtext(), (char)','));
        } else {
            snmpStr.append(',').append("undefined");
        }
        snmpStr.append(',').append(info.getVersion());
        if (info.hasSpecific()) {
            snmpStr.append(',').append(Integer.toString(info.getSpecific()));
        } else {
            snmpStr.append(',').append("undefined");
        }
        if (info.hasGeneric()) {
            snmpStr.append(',').append(Integer.toString(info.getGeneric()));
        } else {
            snmpStr.append(',').append("undefined");
        }
        if (info.getCommunity() != null) {
            snmpStr.append(',').append(info.getCommunity());
        } else {
            snmpStr.append(',').append("undefined");
        }
        return EventDatabaseConstants.format((String)snmpStr.toString(), (int)maxlen);
    }

    public static Snmp createSnmp(String eventSnmp) {
        if (Strings.isNullOrEmpty((String)eventSnmp)) {
            return null;
        }
        String[] snmpFields = eventSnmp.split(String.valueOf(','));
        if (snmpFields.length == 0) {
            return null;
        }
        Iterator<String> fields = Arrays.stream(snmpFields).iterator();
        Snmp snmp = new Snmp();
        snmp.setId((String)fields.next());
        SnmpInfo.setFieldText(fields, arg_0 -> ((Snmp)snmp).setIdtext(arg_0));
        SnmpInfo.setFieldText(fields, arg_0 -> ((Snmp)snmp).setVersion(arg_0));
        SnmpInfo.setFieldValue(fields, arg_0 -> ((Snmp)snmp).setSpecific(arg_0));
        SnmpInfo.setFieldValue(fields, arg_0 -> ((Snmp)snmp).setGeneric(arg_0));
        SnmpInfo.setFieldText(fields, arg_0 -> ((Snmp)snmp).setCommunity(arg_0));
        return snmp;
    }

    private static void setFieldText(Iterator<String> fields, Consumer<String> setter) {
        String fieldValue;
        if (fields.hasNext() && !Strings.isNullOrEmpty((String)(fieldValue = fields.next())) && !fieldValue.equals("undefined")) {
            setter.accept(fieldValue);
        }
    }

    private static void setFieldValue(Iterator<String> fields, Consumer<Integer> setter) {
        String fieldValue;
        if (fields.hasNext() && !Strings.isNullOrEmpty((String)(fieldValue = fields.next())) && !fieldValue.equals("undefined")) {
            setter.accept(StringUtils.parseInt((String)fieldValue, null));
        }
    }
}

