/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.api;

import com.google.common.base.MoreObjects;
import java.net.InetAddress;
import java.util.Objects;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.model.OnmsIpInterface;

public class ServiceRef {
    private final int nodeId;
    private final InetAddress ipAddress;
    private final String serviceName;

    public ServiceRef(int nodeId, InetAddress ipAddress, String serviceName) {
        this.nodeId = nodeId;
        this.ipAddress = Objects.requireNonNull(ipAddress);
        this.serviceName = Objects.requireNonNull(serviceName);
    }

    public static ServiceRef fromEvent(IEvent event) {
        int nodeId = event.getNodeid().intValue();
        String ipAddress = event.getInterface();
        String serviceName = event.getService();
        return new ServiceRef(nodeId, InetAddressUtils.addr((String)ipAddress), serviceName);
    }

    public static ServiceRef fromIpInterface(OnmsIpInterface ipInterface, String serviceName) {
        return new ServiceRef(ipInterface.getNodeId(), ipInterface.getIpAddress(), serviceName);
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceRef)) {
            return false;
        }
        ServiceRef service = (ServiceRef)o;
        return Objects.equals(this.nodeId, service.nodeId) && Objects.equals(this.ipAddress, service.ipAddress) && Objects.equals(this.serviceName, service.serviceName);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.ipAddress, this.serviceName);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nodeId", this.nodeId).add("address", (Object)this.ipAddress).add("serviceName", (Object)this.serviceName).toString();
    }
}

