/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.persistence.api;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpPeer;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.State;

@Table(name="bmp_routers")
@Entity
public class BmpRouter
implements Serializable {
    private static final long serialVersionUID = -5250630896963730366L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="bmpRouterSequence")
    @SequenceGenerator(name="bmpRouterSequence", sequenceName="bmprouternxtid")
    @Column(name="id", nullable=false)
    private Long id;
    @Column(name="hash_id", nullable=false)
    private String hashId;
    @Column(name="name", nullable=false)
    private String name;
    @Column(name="ip_address", nullable=false)
    private String ipAddress;
    @Column(name="router_as")
    private Integer routerAS;
    @Column(name="last_updated", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date timestamp;
    @Column(name="description")
    private String description;
    @Column(name="state")
    @Enumerated(value=EnumType.STRING)
    private State state;
    @Column(name="is_passive")
    private boolean isPassive;
    @Column(name="term_reason_code")
    private Integer termReasonCode;
    @Column(name="term_reason_text")
    private String termReasonText;
    @Column(name="term_data")
    private String termData;
    @Column(name="init_data")
    private String initData;
    @Column(name="geo_ip_start")
    private String geoIpStart;
    @Column(name="collector_hash_id")
    private String collectorHashId;
    @Column(name="bgp_id")
    private String bgpId;
    @Column(name="connection_count")
    private Integer connectionCount;
    @OneToMany(mappedBy="bmpRouter", cascade={CascadeType.ALL})
    private Set<BmpPeer> bmpPeers = new LinkedHashSet<BmpPeer>();
    @Transient
    private String action;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getHashId() {
        return this.hashId;
    }

    public void setHashId(String hashId) {
        this.hashId = hashId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public Integer getRouterAS() {
        return this.routerAS;
    }

    public void setRouterAS(Integer routerAS) {
        this.routerAS = routerAS;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public boolean isPassive() {
        return this.isPassive;
    }

    public void setPassive(boolean passive) {
        this.isPassive = passive;
    }

    public Integer getTermReasonCode() {
        return this.termReasonCode;
    }

    public void setTermReasonCode(Integer termReasonCode) {
        this.termReasonCode = termReasonCode;
    }

    public String getTermReasonText() {
        return this.termReasonText;
    }

    public void setTermReasonText(String termReasonText) {
        this.termReasonText = termReasonText;
    }

    public String getTermData() {
        return this.termData;
    }

    public void setTermData(String termData) {
        this.termData = termData;
    }

    public String getInitData() {
        return this.initData;
    }

    public void setInitData(String initData) {
        this.initData = initData;
    }

    public String getGeoIpStart() {
        return this.geoIpStart;
    }

    public void setGeoIpStart(String geoIpStart) {
        this.geoIpStart = geoIpStart;
    }

    public String getCollectorHashId() {
        return this.collectorHashId;
    }

    public void setCollectorHashId(String collectorHashId) {
        this.collectorHashId = collectorHashId;
    }

    public String getBgpId() {
        return this.bgpId;
    }

    public void setBgpId(String bgpId) {
        this.bgpId = bgpId;
    }

    public Set<BmpPeer> getBmpPeers() {
        return this.bmpPeers;
    }

    public void setBmpPeers(Set<BmpPeer> bmpPeers) {
        this.bmpPeers = bmpPeers;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Integer getConnectionCount() {
        if (this.connectionCount == null) {
            return 0;
        }
        return this.connectionCount;
    }

    public void setConnectionCount(Integer connectionCount) {
        if (connectionCount < 0) {
            connectionCount = 0;
        }
        this.connectionCount = connectionCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BmpRouter bmpRouter = (BmpRouter)o;
        return this.isPassive == bmpRouter.isPassive && Objects.equals(this.hashId, bmpRouter.hashId) && Objects.equals(this.name, bmpRouter.name) && Objects.equals(this.ipAddress, bmpRouter.ipAddress) && Objects.equals(this.routerAS, bmpRouter.routerAS) && Objects.equals(this.timestamp, bmpRouter.timestamp) && Objects.equals(this.description, bmpRouter.description) && this.state == bmpRouter.state && Objects.equals(this.termReasonCode, bmpRouter.termReasonCode) && Objects.equals(this.termReasonText, bmpRouter.termReasonText) && Objects.equals(this.termData, bmpRouter.termData) && Objects.equals(this.initData, bmpRouter.initData) && Objects.equals(this.geoIpStart, bmpRouter.geoIpStart) && Objects.equals(this.bgpId, bmpRouter.bgpId) && Objects.equals(this.collectorHashId, bmpRouter.collectorHashId) && Objects.equals(this.connectionCount, bmpRouter.connectionCount) && Objects.equals(this.action, bmpRouter.action);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hashId, this.name, this.ipAddress, this.routerAS, this.timestamp, this.description, this.state, this.isPassive, this.termReasonCode, this.termReasonText, this.termData, this.initData, this.geoIpStart, this.collectorHashId, this.bgpId, this.connectionCount, this.action});
    }

    public String toString() {
        return "BmpRouter{id=" + this.id + ", hashId='" + this.hashId + "', name='" + this.name + "', ipAddress='" + this.ipAddress + "', routerAS=" + this.routerAS + ", timestamp=" + this.timestamp + ", description='" + this.description + "', state=" + this.state + ", isPassive=" + this.isPassive + ", termReasonCode=" + this.termReasonCode + ", termReasonText='" + this.termReasonText + "', termData='" + this.termData + "', initData='" + this.initData + "', geoIpStart='" + this.geoIpStart + "', collectorHashId='" + this.collectorHashId + "', bgpId='" + this.bgpId + "', connectionCount=" + this.connectionCount + ", bmpPeers=" + this.bmpPeers + ", action='" + this.action + "'}";
    }
}

