/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.service.model.functions.reduce;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.bsm.service.model.StatusWithIndex;
import org.opennms.netmgt.bsm.service.model.StatusWithIndices;

public class StatusUtils {
    protected static List<Integer> getIndicesWithStatusGe(List<StatusWithIndex> statuses, Status threshold) {
        return statuses.stream().filter(si -> si.getStatus().isGreaterThanOrEqual(threshold)).map(StatusWithIndex::getIndex).collect(Collectors.toList());
    }

    protected static List<StatusWithIndex> toListWithIndices(List<Status> statuses) {
        ArrayList<StatusWithIndex> indexedStatuses = new ArrayList<StatusWithIndex>();
        for (int i = 0; i < statuses.size(); ++i) {
            indexedStatuses.add(new StatusWithIndex(statuses.get(i), i));
        }
        return indexedStatuses;
    }

    protected static Optional<Status> getStatus(Optional<StatusWithIndices> si) {
        if (!si.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(si.get().getStatus());
    }
}

